/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.time;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;

public abstract class InstantUtils {
    public static Instant toInstant(Long timeInMs) {
        return InstantUtils.toInstant(timeInMs, null);
    }

    public static Instant toInstant(Long timeInMs, Instant defaultValue) {
        if (timeInMs == null) {
            return defaultValue;
        }
        return Instant.ofEpochMilli(timeInMs);
    }

    public static Instant toInstant(Date date) {
        return InstantUtils.toInstant(date, null);
    }

    public static Instant toInstant(Date date, Instant defaultValue) {
        if (date == null) {
            return defaultValue;
        }
        return date.toInstant();
    }

    public static Instant toInstant(Calendar calendar) {
        return InstantUtils.toInstant(calendar, null);
    }

    public static Instant toInstant(Calendar calendar, Instant defaultValue) {
        if (calendar == null) {
            return defaultValue;
        }
        return calendar.toInstant();
    }

    public static Instant toInstant(LocalDateTime ldt) {
        return InstantUtils.toInstant(ldt, null);
    }

    public static Instant toInstant(LocalDateTime ldt, ZoneId zoneId) {
        return InstantUtils.toInstant(ldt, zoneId, null);
    }

    public static Instant toInstant(LocalDateTime ldt, ZoneId zoneId, Instant defaultValue) {
        if (ldt == null) {
            return defaultValue;
        }
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        return ldt.toInstant(OffsetDateTime.now(zoneId).getOffset());
    }

    public static Instant toInstant(LocalDate ld) {
        return InstantUtils.toInstant(ld, null);
    }

    public static Instant toInstant(LocalDate ld, ZoneId zoneId) {
        return InstantUtils.toInstant(ld, zoneId, null);
    }

    public static Instant toInstant(LocalDate ld, ZoneId zoneId, Instant defaultValue) {
        if (ld == null) {
            return defaultValue;
        }
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        return ld.atTime(0, 0, 0).toInstant(OffsetDateTime.now(zoneId).getOffset());
    }
}

