/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.time;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.collection.LruMap;
import com.github.paganini2008.devtools.time.InstantUtils;
import com.github.paganini2008.devtools.time.LocalDateUtils;
import com.github.paganini2008.devtools.time.TimeAssert;
import com.github.paganini2008.devtools.time.YearMonthUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;

public abstract class LocalDateTimeUtils {
    public static final LocalDateTime[] EMPTY_ARRAY = new LocalDateTime[0];
    private static final LruMap<String, DateTimeFormatter> dfCache = new LruMap(16);

    public static LocalDateTime addSeconds(Date date, int seconds) {
        return LocalDateTimeUtils.addSeconds(LocalDateTimeUtils.toLocalDateTime(date, null), seconds);
    }

    public static LocalDateTime addSeconds(int seconds) {
        return LocalDateTimeUtils.addSeconds(LocalDateTime.now(), seconds);
    }

    public static LocalDateTime addSeconds(LocalDateTime localDateTime, int seconds) {
        return LocalDateTimeUtils.addAmount(localDateTime, seconds, ChronoUnit.SECONDS);
    }

    public static LocalDateTime addMinutes(Date date, int minutes) {
        return LocalDateTimeUtils.addMinutes(LocalDateTimeUtils.toLocalDateTime(date, null), minutes);
    }

    public static LocalDateTime addMinutes(int minutes) {
        return LocalDateTimeUtils.addMinutes(LocalDateTime.now(), minutes);
    }

    public static LocalDateTime addMinutes(LocalDateTime localDateTime, int minutes) {
        return LocalDateTimeUtils.addAmount(localDateTime, minutes, ChronoUnit.MINUTES);
    }

    public static LocalDateTime addHours(Date date, int hours) {
        return LocalDateTimeUtils.addHours(LocalDateTimeUtils.toLocalDateTime(date, null), hours);
    }

    public static LocalDateTime addHours(int hours) {
        return LocalDateTimeUtils.addHours(LocalDateTime.now(), hours);
    }

    public static LocalDateTime addHours(LocalDateTime localDateTime, int hours) {
        return LocalDateTimeUtils.addAmount(localDateTime, hours, ChronoUnit.HOURS);
    }

    public static LocalDateTime addDays(Date date, int days) {
        return LocalDateTimeUtils.addDays(LocalDateTimeUtils.toLocalDateTime(date, null), days);
    }

    public static LocalDateTime addDays(int days) {
        return LocalDateTimeUtils.addDays(LocalDateTime.now(), days);
    }

    public static LocalDateTime addDays(LocalDateTime localDateTime, int days) {
        return LocalDateTimeUtils.addAmount(localDateTime, days, ChronoUnit.DAYS);
    }

    public static LocalDateTime addMonths(Date date, int months) {
        return LocalDateTimeUtils.addMonths(LocalDateTimeUtils.toLocalDateTime(date, null), months);
    }

    public static LocalDateTime addMonths(int months) {
        return LocalDateTimeUtils.addMonths(LocalDateTime.now(), months);
    }

    public static LocalDateTime addMonths(LocalDateTime localDateTime, int months) {
        return LocalDateTimeUtils.addAmount(localDateTime, months, ChronoUnit.MONTHS);
    }

    public static LocalDateTime addYears(Date date, int years) {
        return LocalDateTimeUtils.addDays(LocalDateTimeUtils.toLocalDateTime(date, null), years);
    }

    public static LocalDateTime addYears(int years) {
        return LocalDateTimeUtils.addYears(LocalDateTime.now(), years);
    }

    public static LocalDateTime addYears(LocalDateTime localDateTime, int years) {
        return LocalDateTimeUtils.addAmount(localDateTime, years, ChronoUnit.YEARS);
    }

    public static LocalDateTime addWeeks(Date date, int weeks) {
        return LocalDateTimeUtils.addWeeks(LocalDateTimeUtils.toLocalDateTime(date, null), weeks);
    }

    public static LocalDateTime addWeeks(int weeks) {
        return LocalDateTimeUtils.addWeeks(LocalDateTime.now(), weeks);
    }

    public static LocalDateTime addWeeks(LocalDateTime localDateTime, int weeks) {
        return LocalDateTimeUtils.addAmount(localDateTime, weeks, ChronoUnit.WEEKS);
    }

    public static LocalDateTime addAmount(LocalDateTime localDateTime, int amount, ChronoUnit chronoUnit) {
        if (localDateTime == null) {
            localDateTime = LocalDateTime.now();
        }
        return localDateTime.plus(amount, chronoUnit);
    }

    public static int getYear(LocalDateTime localDateTime) {
        return LocalDateTimeUtils.getField(localDateTime, ChronoField.YEAR);
    }

    public static int getMonth(LocalDateTime localDateTime) {
        return LocalDateTimeUtils.getField(localDateTime, ChronoField.MONTH_OF_YEAR);
    }

    public static int getDayOfMonth(LocalDateTime localDateTime) {
        return LocalDateTimeUtils.getField(localDateTime, ChronoField.DAY_OF_MONTH);
    }

    public static int getDayOfWeek(LocalDateTime localDateTime) {
        return LocalDateTimeUtils.getField(localDateTime, ChronoField.DAY_OF_WEEK);
    }

    public static int getDayOfYear(LocalDateTime localDateTime) {
        return LocalDateTimeUtils.getField(localDateTime, ChronoField.DAY_OF_YEAR);
    }

    public static int getHourOfDay(LocalDateTime localDateTime) {
        return LocalDateTimeUtils.getField(localDateTime, ChronoField.HOUR_OF_DAY);
    }

    public static int getMinute(LocalDateTime localDateTime) {
        return LocalDateTimeUtils.getField(localDateTime, ChronoField.MINUTE_OF_HOUR);
    }

    public static int getSecond(LocalDateTime localDateTime) {
        return LocalDateTimeUtils.getField(localDateTime, ChronoField.SECOND_OF_MINUTE);
    }

    public static int getField(LocalDateTime localDateTime, ChronoField field) {
        if (localDateTime == null) {
            localDateTime = LocalDateTime.now();
        }
        return localDateTime.get(field);
    }

    public static LocalDateTime setYear(int year) {
        return LocalDateTimeUtils.setYear(LocalDateTime.now(), year);
    }

    public static LocalDateTime setYear(LocalDateTime localDateTime, int year) {
        return LocalDateTimeUtils.setField(localDateTime, ChronoField.YEAR, year);
    }

    public static LocalDateTime setMonth(int month) {
        return LocalDateTimeUtils.setMonth(LocalDateTime.now(), month);
    }

    public static LocalDateTime setMonth(LocalDateTime localDateTime, int month) {
        return LocalDateTimeUtils.setField(localDateTime, ChronoField.MONTH_OF_YEAR, month);
    }

    public static LocalDateTime setDayOfMonth(int dayOfMonth) {
        return LocalDateTimeUtils.setDayOfMonth(LocalDateTime.now(), dayOfMonth);
    }

    public static LocalDateTime setDayOfMonth(LocalDateTime localDateTime, int dayOfMonth) {
        return LocalDateTimeUtils.setField(localDateTime, ChronoField.DAY_OF_MONTH, dayOfMonth);
    }

    public static LocalDateTime setDayOfWeek(int dayOfWeek) {
        return LocalDateTimeUtils.setDayOfWeek(LocalDateTime.now(), dayOfWeek);
    }

    public static LocalDateTime setDayOfWeek(LocalDateTime localDateTime, int dayOfWeek) {
        return LocalDateTimeUtils.setField(localDateTime, ChronoField.DAY_OF_WEEK, dayOfWeek);
    }

    public static LocalDateTime setDayOfYear(int dayOfYear) {
        return LocalDateTimeUtils.setDayOfYear(LocalDateTime.now(), dayOfYear);
    }

    public static LocalDateTime setDayOfYear(LocalDateTime localDateTime, int dayOfYear) {
        return LocalDateTimeUtils.setField(localDateTime, ChronoField.DAY_OF_YEAR, dayOfYear);
    }

    public static LocalDateTime setHourOfDay(int hourOfDay) {
        return LocalDateTimeUtils.setHourOfDay(LocalDateTime.now(), hourOfDay);
    }

    public static LocalDateTime setHourOfDay(LocalDateTime localDateTime, int hourOfDay) {
        return LocalDateTimeUtils.setField(localDateTime, ChronoField.HOUR_OF_DAY, hourOfDay);
    }

    public static LocalDateTime setMinute(int minute) {
        return LocalDateTimeUtils.setMinute(LocalDateTime.now(), minute);
    }

    public static LocalDateTime setMinute(LocalDateTime localDateTime, int minute) {
        return LocalDateTimeUtils.setField(localDateTime, ChronoField.MINUTE_OF_HOUR, minute);
    }

    public static LocalDateTime setSecond(int second) {
        return LocalDateTimeUtils.setSecond(LocalDateTime.now(), second);
    }

    public static LocalDateTime setSecond(LocalDateTime localDateTime, int second) {
        return LocalDateTimeUtils.setField(localDateTime, ChronoField.SECOND_OF_MINUTE, second);
    }

    public static LocalDateTime setField(LocalDateTime localDateTime, ChronoField field, int value) {
        if (localDateTime == null) {
            localDateTime = LocalDateTime.now();
        }
        return localDateTime.with(field, value);
    }

    public static LocalDateTime toLocalDateTime(Long ms, ZoneId zoneId) {
        return LocalDateTimeUtils.toLocalDateTime(ms, zoneId, null);
    }

    public static LocalDateTime toLocalDateTime(Long ms, ZoneId zoneId, LocalDateTime defaultValue) {
        if (ms == null) {
            return defaultValue;
        }
        return LocalDateTimeUtils.toLocalDateTime(Instant.ofEpochMilli(ms), zoneId, defaultValue);
    }

    public static LocalDateTime toLocalDateTime(Instant instant, ZoneId zoneId) {
        return LocalDateTimeUtils.toLocalDateTime(instant, zoneId, null);
    }

    public static LocalDateTime toLocalDateTime(Instant instant, ZoneId zoneId, LocalDateTime defaultValue) {
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        try {
            return instant != null ? instant.atZone(zoneId).toLocalDateTime() : defaultValue;
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static LocalDateTime toLocalDateTime(Date date, ZoneId zoneId) {
        return LocalDateTimeUtils.toLocalDateTime(date, zoneId, null);
    }

    public static LocalDateTime toLocalDateTime(Date date, ZoneId zoneId, LocalDateTime defaultValue) {
        if (date == null) {
            return defaultValue;
        }
        return LocalDateTimeUtils.toLocalDateTime(date.toInstant(), zoneId, defaultValue);
    }

    public static LocalDateTime toLocalDateTime(Calendar calendar, ZoneId zoneId) {
        return LocalDateTimeUtils.toLocalDateTime(calendar, zoneId, null);
    }

    public static LocalDateTime toLocalDateTime(Calendar calendar, ZoneId zoneId, LocalDateTime defaultValue) {
        if (calendar == null) {
            return defaultValue;
        }
        return LocalDateTimeUtils.toLocalDateTime(calendar.toInstant(), zoneId, defaultValue);
    }

    public static LocalDateTime toLocalDateTime(LocalDate ld) {
        return LocalDateTimeUtils.toLocalDateTime(ld, null);
    }

    public static LocalDateTime toLocalDateTime(LocalDate ld, LocalDateTime defaultValue) {
        if (ld == null) {
            return defaultValue;
        }
        try {
            return ld.atTime(0, 0, 0);
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static String format(LocalDateTime localDateTime, String datePattern) {
        return LocalDateTimeUtils.format(localDateTime, datePattern, "");
    }

    public static String format(LocalDateTime localDateTime, String datePattern, String defaultValue) {
        return localDateTime != null ? localDateTime.format(LocalDateTimeUtils.getDateTimeFormatter(datePattern)) : defaultValue;
    }

    public static String format(LocalDateTime localDateTime) {
        return LocalDateTimeUtils.format(localDateTime, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static String format(LocalDateTime localDateTime, DateTimeFormatter dateTimeFormatter) {
        return LocalDateTimeUtils.format(localDateTime, dateTimeFormatter, "");
    }

    public static String format(LocalDateTime localDateTime, DateTimeFormatter dateTimeFormatter, String defaultValue) {
        return localDateTime != null ? localDateTime.format(dateTimeFormatter) : defaultValue;
    }

    public static LocalDateTime parseLocalDateTime(String text) {
        return LocalDateTimeUtils.parseLocalDateTime(text, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static LocalDateTime parseLocalDateTime(String text, DateTimeFormatter formatter) {
        return LocalDateTimeUtils.parseLocalDateTime(text, formatter, null);
    }

    public static LocalDateTime parseLocalDateTime(String text, DateTimeFormatter formatter, LocalDateTime defaultValue) {
        if (formatter == null) {
            formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        }
        try {
            return StringUtils.isNotBlank(text) ? LocalDateTime.parse(text, formatter) : defaultValue;
        }
        catch (DateTimeParseException e) {
            return defaultValue;
        }
    }

    public static LocalDateTime parseLocalDateTime(String text, String datePattern) {
        return LocalDateTimeUtils.parseLocalDateTime(text, datePattern, null);
    }

    public static LocalDateTime parseLocalDateTime(String text, String datePattern, LocalDateTime defaultValue) {
        return LocalDateTimeUtils.parseLocalDateTime(text, LocalDateTimeUtils.getDateTimeFormatter(datePattern), defaultValue);
    }

    public static LocalDateTime of(YearMonth yearMonth, int dayOfMonth, int hourOfDay, int minute, int second) {
        if (yearMonth == null) {
            yearMonth = YearMonth.now();
        }
        TimeAssert.validateTime(hourOfDay, minute, second);
        return yearMonth.atDay(dayOfMonth).atTime(hourOfDay, minute, second);
    }

    public static LocalDateTime of(Year year, Month month, int dayOfMonth, int hourOfDay, int minute, int second) {
        YearMonth yearMonth = YearMonthUtils.toYearMonth(year, month);
        return LocalDateTimeUtils.of(yearMonth, dayOfMonth, hourOfDay, minute, second);
    }

    public static LocalDateTime of(Date date, int hourOfDay, int minute, int second) {
        LocalDate localDate = LocalDateUtils.toLocalDate(date, null);
        return LocalDateTimeUtils.of(localDate, hourOfDay, minute, second);
    }

    public static LocalDateTime of(LocalDate localDate, int hourOfDay, int minute, int second) {
        if (localDate == null) {
            localDate = LocalDate.now();
        }
        TimeAssert.validateTime(hourOfDay, minute, second);
        return localDate.atTime(hourOfDay, minute, second);
    }

    public static LocalDateTime of(int year, int month, int dayOfMonth) {
        return LocalDateTimeUtils.of(year, month, dayOfMonth, 0, 0, 0);
    }

    public static LocalDateTime of(int year, int month, int dayOfMonth, int hourOfDay, int minute, int second) {
        TimeAssert.validateYear(year);
        TimeAssert.validateMonth(month);
        TimeAssert.validateDayOfMonth(year, month, dayOfMonth);
        TimeAssert.validateTime(hourOfDay, minute, second);
        return LocalDateTime.of(year, month, dayOfMonth, hourOfDay, minute, second);
    }

    private static DateTimeFormatter getDateTimeFormatter(String datePattern) {
        Assert.hasNoText(datePattern, "DatePattern can not be blank.", new Object[0]);
        DateTimeFormatter sdf = dfCache.get(datePattern);
        if (sdf == null) {
            dfCache.putIfAbsent(datePattern, DateTimeFormatter.ofPattern(datePattern, Locale.ENGLISH));
            sdf = dfCache.get(datePattern);
        }
        return sdf;
    }

    public static LocalDateTime copy(LocalDateTime ldt, ZoneId zoneId) {
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        if (ldt == null) {
            return LocalDateTime.now(zoneId);
        }
        Instant ins = InstantUtils.toInstant(ldt, zoneId);
        return LocalDateTime.ofInstant(ins, zoneId);
    }

    public static long until(LocalDateTime endTime) {
        return LocalDateTimeUtils.until(null, endTime);
    }

    public static long until(LocalDateTime startTime, LocalDateTime endTime) {
        Assert.isNull(endTime, "EndTime must not be null", new Object[0]);
        if (startTime == null) {
            startTime = LocalDateTime.now();
        }
        return startTime.until(endTime, ChronoUnit.MILLIS);
    }

    public static Iterator<LocalDateTime> toIterator(String startTime, String endTime, DateTimeFormatter dtf, ZoneId zoneId, int interval, ChronoUnit chronoUnit) {
        return new LocalDateTimeIterator(LocalDateTimeUtils.parseLocalDateTime(startTime, dtf), LocalDateTimeUtils.parseLocalDateTime(endTime, dtf), zoneId, interval, chronoUnit);
    }

    public static Iterator<LocalDateTime> toIterator(Date startTime, Date endTime, ZoneId zoneId, int interval, ChronoUnit chronoUnit) {
        return new LocalDateTimeIterator(LocalDateTimeUtils.toLocalDateTime(startTime, zoneId), LocalDateTimeUtils.toLocalDateTime(endTime, zoneId), zoneId, interval, chronoUnit);
    }

    public static Iterator<LocalDateTime> toIterator(LocalDateTime startTime, LocalDateTime endTime, ZoneId zoneId, int interval, ChronoUnit chronoUnit) {
        return new LocalDateTimeIterator(startTime, endTime, zoneId, interval, chronoUnit);
    }

    static class LocalDateTimeIterator
    implements Iterator<LocalDateTime> {
        private LocalDateTime startTime;
        private LocalDateTime endTime;
        private ZoneId zoneId;
        private int interval;
        private ChronoUnit chronoUnit;

        LocalDateTimeIterator(LocalDateTime startTime, LocalDateTime endTime, ZoneId zoneId, int interval, ChronoUnit chronoUnit) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.zoneId = zoneId;
            this.interval = interval;
            this.chronoUnit = chronoUnit;
        }

        @Override
        public boolean hasNext() {
            return this.startTime.isBefore(this.endTime);
        }

        @Override
        public LocalDateTime next() {
            LocalDateTime copy = LocalDateTimeUtils.copy(this.startTime, this.zoneId);
            this.startTime = this.startTime.plus(this.interval, this.chronoUnit);
            return copy;
        }
    }
}

