/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.time;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.collection.LruMap;
import com.github.paganini2008.devtools.time.LocalDateTimeUtils;
import com.github.paganini2008.devtools.time.TimeAssert;
import com.github.paganini2008.devtools.time.YearMonthUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;

public abstract class LocalDateUtils {
    public static final LocalDate[] EMPTY_ARRAY = new LocalDate[0];
    private static final LruMap<String, DateTimeFormatter> dfCache = new LruMap(16);

    public static LocalDate addYears(Date date, int years) {
        return LocalDateUtils.addDays(LocalDateUtils.toLocalDate(date, null), years);
    }

    public static LocalDate addYears(int years) {
        return LocalDateUtils.addYears(LocalDate.now(), years);
    }

    public static LocalDate addYears(LocalDate localDate, int years) {
        return LocalDateUtils.addAmount(localDate, years, ChronoUnit.YEARS);
    }

    public static LocalDate addMonths(Date date, int months) {
        return LocalDateUtils.addMonths(LocalDateUtils.toLocalDate(date, null), months);
    }

    public static LocalDate addMonths(int months) {
        return LocalDateUtils.addMonths(LocalDate.now(), months);
    }

    public static LocalDate addMonths(LocalDate localDate, int months) {
        return LocalDateUtils.addAmount(localDate, months, ChronoUnit.MONTHS);
    }

    public static LocalDate addDays(Date date, int days) {
        return LocalDateUtils.addDays(LocalDateUtils.toLocalDate(date, null), days);
    }

    public static LocalDate addDays(int days) {
        return LocalDateUtils.addDays(LocalDate.now(), days);
    }

    public static LocalDate addDays(LocalDate localDate, int days) {
        return LocalDateUtils.addAmount(localDate, days, ChronoUnit.DAYS);
    }

    public static LocalDate addWeeks(Date date, int weeks) {
        return LocalDateUtils.addWeeks(LocalDateUtils.toLocalDate(date, null), weeks);
    }

    public static LocalDate addWeeks(int weeks) {
        return LocalDateUtils.addWeeks(LocalDate.now(), weeks);
    }

    public static LocalDate addWeeks(LocalDate localDate, int weeks) {
        return LocalDateUtils.addAmount(localDate, weeks, ChronoUnit.WEEKS);
    }

    public static LocalDate addAmount(LocalDate localDate, int amount, ChronoUnit chronoUnit) {
        if (localDate == null) {
            localDate = LocalDate.now();
        }
        return localDate.plus(amount, chronoUnit);
    }

    public static LocalDate setYear(int year) {
        return LocalDateUtils.setYear(LocalDate.now(), year);
    }

    public static LocalDate setYear(Date date, int year) {
        return LocalDateUtils.setYear(LocalDateUtils.toLocalDate(date, null), year);
    }

    public static LocalDate setYear(LocalDate localDate, int year) {
        return LocalDateUtils.setField(localDate, ChronoField.YEAR, year);
    }

    public static LocalDate setMonth(int month) {
        return LocalDateUtils.setMonth(LocalDate.now(), month);
    }

    public static LocalDate setMonth(Date date, int month) {
        return LocalDateUtils.setMonth(LocalDateUtils.toLocalDate(date, null), month);
    }

    public static LocalDate setMonth(LocalDate localDate, int month) {
        return LocalDateUtils.setField(localDate, ChronoField.MONTH_OF_YEAR, month);
    }

    public static LocalDate setDayOfMonth(int dayOfMonth) {
        return LocalDateUtils.setDayOfMonth(LocalDate.now(), dayOfMonth);
    }

    public static LocalDate setDayOfMonth(Date date, int dayOfMonth) {
        return LocalDateUtils.setDayOfMonth(LocalDateUtils.toLocalDate(date, null), dayOfMonth);
    }

    public static LocalDate setDayOfMonth(LocalDate localDate, int dayOfMonth) {
        return LocalDateUtils.setField(localDate, ChronoField.DAY_OF_MONTH, dayOfMonth);
    }

    public static LocalDate setDayOfWeek(int dayOfWeek) {
        return LocalDateUtils.setDayOfMonth(LocalDate.now(), dayOfWeek);
    }

    public static LocalDate setDayOfWeek(Date date, int dayOfWeek) {
        return LocalDateUtils.setDayOfWeek(LocalDateUtils.toLocalDate(date, null), dayOfWeek);
    }

    public static LocalDate setDayOfWeek(LocalDate localDate, int dayOfWeek) {
        return LocalDateUtils.setField(localDate, ChronoField.DAY_OF_WEEK, dayOfWeek);
    }

    public static LocalDate setDayOfYear(int dayOfYear) {
        return LocalDateUtils.setDayOfYear(LocalDate.now(), dayOfYear);
    }

    public static LocalDate setDayOfYear(Date date, int dayOfYear) {
        return LocalDateUtils.setDayOfYear(LocalDateUtils.toLocalDate(date, null), dayOfYear);
    }

    public static LocalDate setDayOfYear(LocalDate localDate, int dayOfYear) {
        return LocalDateUtils.setField(localDate, ChronoField.DAY_OF_YEAR, dayOfYear);
    }

    public static LocalDate setField(LocalDate localDate, ChronoField field, int value) {
        if (localDate == null) {
            localDate = LocalDate.now();
        }
        return localDate.with(field, value);
    }

    public static LocalDate toLocalDate(Long ms, ZoneId zoneId) {
        return LocalDateUtils.toLocalDate(ms, zoneId, null);
    }

    public static LocalDate toLocalDate(Long ms, ZoneId zoneId, LocalDate defaultValue) {
        if (ms == null) {
            return defaultValue;
        }
        return LocalDateUtils.toLocalDate(Instant.ofEpochMilli(ms), zoneId, defaultValue);
    }

    public static LocalDate toLocalDate(Instant instant, ZoneId zoneId) {
        return LocalDateUtils.toLocalDate(instant, zoneId, null);
    }

    public static LocalDate toLocalDate(Instant instant, ZoneId zoneId, LocalDate defaultValue) {
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        try {
            return instant != null ? instant.atZone(zoneId).toLocalDate() : defaultValue;
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static LocalDate toLocalDate(Date date, ZoneId zoneId) {
        return LocalDateUtils.toLocalDate(date, zoneId, null);
    }

    public static LocalDate toLocalDate(Date date, ZoneId zoneId, LocalDate defaultValue) {
        if (date == null) {
            return defaultValue;
        }
        return LocalDateUtils.toLocalDate(date.toInstant(), zoneId, defaultValue);
    }

    public static LocalDate toLocalDate(Calendar calendar, ZoneId zoneId) {
        return LocalDateUtils.toLocalDate(calendar, zoneId, null);
    }

    public static LocalDate toLocalDate(Calendar calendar, ZoneId zoneId, LocalDate defaultValue) {
        if (calendar == null) {
            return defaultValue;
        }
        return LocalDateUtils.toLocalDate(calendar.toInstant(), zoneId, defaultValue);
    }

    public static LocalDate toLocalDate(LocalDateTime ldt, LocalDate defaultValue) {
        if (ldt == null) {
            return defaultValue;
        }
        return ldt.toLocalDate();
    }

    public static String format(LocalDate localDate) {
        return LocalDateUtils.format(localDate, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static String format(LocalDate localDate, DateTimeFormatter dateTimeFormatter) {
        return LocalDateUtils.format(localDate, dateTimeFormatter, "");
    }

    public static String format(LocalDate localDate, DateTimeFormatter dateTimeFormatter, String defaultValue) {
        return localDate != null ? localDate.format(dateTimeFormatter) : defaultValue;
    }

    public static String format(LocalDate localDate, String datePattern) {
        return LocalDateUtils.format(localDate, datePattern, "");
    }

    public static String format(LocalDate localDate, String datePattern, String defaultValue) {
        return localDate != null ? localDate.format(LocalDateUtils.getDateTimeFormatter(datePattern)) : defaultValue;
    }

    public static LocalDate parseLocalDate(String text) {
        return LocalDateUtils.parseLocalDate(text, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static LocalDate parseLocalDate(String text, DateTimeFormatter formatter) {
        return LocalDateUtils.parseLocalDate(text, formatter, null);
    }

    public static LocalDate parseLocalDate(String text, DateTimeFormatter formatter, LocalDate defaultValue) {
        if (formatter == null) {
            formatter = DateTimeFormatter.ISO_LOCAL_DATE;
        }
        try {
            return StringUtils.isNotBlank(text) ? LocalDate.parse(text, formatter) : defaultValue;
        }
        catch (DateTimeParseException e) {
            return defaultValue;
        }
    }

    public static LocalDate parseLocalDate(String text, String datePattern) {
        return LocalDateUtils.parseLocalDate(text, datePattern, null);
    }

    public static LocalDate parseLocalDate(String text, String datePattern, LocalDate defaultValue) {
        return LocalDateUtils.parseLocalDate(text, LocalDateUtils.getDateTimeFormatter(datePattern), defaultValue);
    }

    public static LocalDate of(Year year, int dayOfYear) {
        TimeAssert.validateDayOfYear(year, dayOfYear);
        return year.atDay(dayOfYear);
    }

    public static LocalDate of(YearMonth yearMonth, int dayOfMonth) {
        TimeAssert.validateDayOfMonth(yearMonth, dayOfMonth);
        return yearMonth.atDay(dayOfMonth);
    }

    public static LocalDate of(Year year, Month month, int dayOfMonth) {
        YearMonth yearMonth = YearMonthUtils.toYearMonth(year, month);
        return LocalDateUtils.of(yearMonth, dayOfMonth);
    }

    public static LocalDate of(int year, int month, int dayOfMonth) {
        TimeAssert.validateYear(year);
        TimeAssert.validateMonth(month);
        TimeAssert.validateDayOfMonth(year, month, dayOfMonth);
        return LocalDate.of(year, month, dayOfMonth);
    }

    private static DateTimeFormatter getDateTimeFormatter(String datePattern) {
        Assert.hasNoText(datePattern, "DatePattern can not be blank.", new Object[0]);
        DateTimeFormatter sdf = dfCache.get(datePattern);
        if (sdf == null) {
            dfCache.putIfAbsent(datePattern, DateTimeFormatter.ofPattern(datePattern, Locale.ENGLISH));
            sdf = dfCache.get(datePattern);
        }
        return sdf;
    }

    public static LocalDate copy(LocalDate ld, ZoneId zoneId) {
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        if (ld == null) {
            return LocalDate.now(zoneId);
        }
        LocalDateTime ldt = LocalDateTime.of(ld, LocalTime.now(zoneId));
        return LocalDateTimeUtils.copy(ldt, zoneId).toLocalDate();
    }

    public static Iterator<LocalDate> toIterator(String startTime, String endTime, DateTimeFormatter dtf, ZoneId zoneId, int interval, ChronoUnit chronoUnit) {
        return new LocalDateIterator(LocalDateUtils.parseLocalDate(startTime, dtf), LocalDateUtils.parseLocalDate(endTime, dtf), zoneId, interval, chronoUnit);
    }

    public static Iterator<LocalDate> toIterator(Date startTime, Date endTime, ZoneId zoneId, int interval, ChronoUnit chronoUnit) {
        return new LocalDateIterator(LocalDateUtils.toLocalDate(startTime, zoneId), LocalDateUtils.toLocalDate(endTime, zoneId), zoneId, interval, chronoUnit);
    }

    public static Iterator<LocalDate> toIterator(LocalDate startTime, LocalDate endTime, ZoneId zoneId, int interval, ChronoUnit chronoUnit) {
        return new LocalDateIterator(startTime, endTime, zoneId, interval, chronoUnit);
    }

    static class LocalDateIterator
    implements Iterator<LocalDate> {
        private LocalDate startDate;
        private LocalDate endDate;
        private ZoneId zoneId;
        private int interval;
        private ChronoUnit chronoUnit;

        LocalDateIterator(LocalDate startDate, LocalDate endDate, ZoneId zoneId, int interval, ChronoUnit chronoUnit) {
            this.startDate = startDate;
            this.endDate = endDate;
            this.zoneId = zoneId;
            this.interval = interval;
            this.chronoUnit = chronoUnit;
        }

        @Override
        public boolean hasNext() {
            return this.startDate.isBefore(this.endDate);
        }

        @Override
        public LocalDate next() {
            LocalDate copy = LocalDateUtils.copy(this.startDate, this.zoneId);
            this.startDate = this.startDate.plus(this.interval, this.chronoUnit);
            return copy;
        }
    }
}

