/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.time;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.collection.LruMap;
import com.github.paganini2008.devtools.time.LocalDateTimeUtils;
import com.github.paganini2008.devtools.time.TimeAssert;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;

public abstract class LocalTimeUtils {
    public static final LocalTime[] EMPTY_ARRAY = new LocalTime[0];
    private static final LruMap<String, DateTimeFormatter> dfCache = new LruMap(16);

    public static LocalTime toLocalTime(Long ms, ZoneId zoneId) {
        return LocalTimeUtils.toLocalTime(ms, zoneId, null);
    }

    public static LocalTime toLocalTime(Long ms, ZoneId zoneId, LocalTime defaultValue) {
        if (ms == null) {
            return defaultValue;
        }
        return LocalTimeUtils.toLocalTime(Instant.ofEpochMilli(ms), zoneId, defaultValue);
    }

    public static LocalTime toLocalTime(Instant instant, ZoneId zoneId) {
        return LocalTimeUtils.toLocalTime(instant, zoneId, null);
    }

    public static LocalTime toLocalTime(Instant instant, ZoneId zoneId, LocalTime defaultValue) {
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        try {
            return instant != null ? instant.atZone(zoneId).toLocalTime() : defaultValue;
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static LocalTime toLocalTime(Date date, ZoneId zoneId) {
        return LocalTimeUtils.toLocalTime(date, zoneId, null);
    }

    public static LocalTime toLocalTime(Date date, ZoneId zoneId, LocalTime defaultValue) {
        if (date == null) {
            return defaultValue;
        }
        return LocalTimeUtils.toLocalTime(date.toInstant(), zoneId, defaultValue);
    }

    public static LocalTime toLocalTime(Calendar calendar, ZoneId zoneId) {
        return LocalTimeUtils.toLocalTime(calendar, zoneId, null);
    }

    public static LocalTime toLocalTime(Calendar calendar, ZoneId zoneId, LocalTime defaultValue) {
        if (calendar == null) {
            return defaultValue;
        }
        return LocalTimeUtils.toLocalTime(calendar.toInstant(), zoneId, defaultValue);
    }

    public static LocalTime toLocalTime(LocalDateTime ldt, LocalTime defaultValue) {
        if (ldt == null) {
            return defaultValue;
        }
        return ldt.toLocalTime();
    }

    public static LocalTime parseLocalTime(String text) {
        return LocalTimeUtils.parseLocalTime(text, DateTimeFormatter.ISO_LOCAL_TIME);
    }

    public static LocalTime parseLocalTime(String text, DateTimeFormatter formatter) {
        return LocalTimeUtils.parseLocalTime(text, formatter, null);
    }

    public static LocalTime parseLocalTime(String text, DateTimeFormatter formatter, LocalTime defaultValue) {
        if (formatter == null) {
            formatter = DateTimeFormatter.ISO_LOCAL_TIME;
        }
        try {
            return StringUtils.isNotBlank(text) ? LocalTime.parse(text, formatter) : defaultValue;
        }
        catch (DateTimeParseException e) {
            return defaultValue;
        }
    }

    public static LocalTime parseLocalTime(String text, String datePattern) {
        return LocalTimeUtils.parseLocalTime(text, datePattern, null);
    }

    public static LocalTime parseLocalTime(String text, String datePattern, LocalTime defaultValue) {
        return LocalTimeUtils.parseLocalTime(text, LocalTimeUtils.getDateTimeFormatter(datePattern), defaultValue);
    }

    public static LocalTime of(int hourOfDay, int minute) {
        return LocalTimeUtils.of(hourOfDay, minute, 0);
    }

    public static LocalTime of(int hourOfDay, int minute, int second) {
        TimeAssert.validateTime(hourOfDay, minute, second);
        return LocalTime.of(hourOfDay, minute, second);
    }

    private static DateTimeFormatter getDateTimeFormatter(String datePattern) {
        Assert.hasNoText(datePattern, "DatePattern can not be blank.", new Object[0]);
        DateTimeFormatter sdf = dfCache.get(datePattern);
        if (sdf == null) {
            dfCache.putIfAbsent(datePattern, DateTimeFormatter.ofPattern(datePattern, Locale.ENGLISH));
            sdf = dfCache.get(datePattern);
        }
        return sdf;
    }

    public static LocalTime copy(LocalTime lt, ZoneId zoneId) {
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        if (lt == null) {
            return LocalTime.now(zoneId);
        }
        LocalDateTime ldt = LocalDateTime.of(LocalDate.now(zoneId), lt);
        return LocalDateTimeUtils.copy(ldt, zoneId).toLocalTime();
    }

    public static Iterator<LocalTime> toIterator(String startTime, String endTime, DateTimeFormatter dtf, ZoneId zoneId, int interval, ChronoUnit chronoUnit) {
        return new LocalTimeIterator(LocalTimeUtils.parseLocalTime(startTime, dtf), LocalTimeUtils.parseLocalTime(endTime, dtf), zoneId, interval, chronoUnit);
    }

    public static Iterator<LocalTime> toIterator(Date startTime, Date endTime, ZoneId zoneId, int interval, ChronoUnit chronoUnit) {
        return new LocalTimeIterator(LocalTimeUtils.toLocalTime(startTime, zoneId), LocalTimeUtils.toLocalTime(endTime, zoneId), zoneId, interval, chronoUnit);
    }

    public static Iterator<LocalTime> toIterator(LocalTime startTime, LocalTime endTime, ZoneId zoneId, int interval, ChronoUnit chronoUnit) {
        return new LocalTimeIterator(startTime, endTime, zoneId, interval, chronoUnit);
    }

    static class LocalTimeIterator
    implements Iterator<LocalTime> {
        private LocalTime startTime;
        private LocalTime endTime;
        private ZoneId zoneId;
        private int interval;
        private ChronoUnit chronoUnit;

        LocalTimeIterator(LocalTime startTime, LocalTime endTime, ZoneId zoneId, int interval, ChronoUnit chronoUnit) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.zoneId = zoneId;
            this.interval = interval;
            this.chronoUnit = chronoUnit;
        }

        @Override
        public boolean hasNext() {
            return this.startTime.isBefore(this.endTime);
        }

        @Override
        public LocalTime next() {
            LocalTime copy = LocalTimeUtils.copy(this.startTime, this.zoneId);
            this.startTime = this.startTime.plus(this.interval, this.chronoUnit);
            return copy;
        }
    }
}

