/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.time;

import com.github.paganini2008.devtools.collection.AtomicMutableMap;
import com.github.paganini2008.devtools.time.MergeableFunction;
import com.github.paganini2008.devtools.time.TimeSlot;
import com.github.paganini2008.devtools.time.TimeSlotMap;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicStampedReference;
import java.util.stream.Collectors;

public class MergeableTimeSlotMap<V extends MergeableFunction<V>>
extends AtomicMutableMap<Instant, V>
implements TimeSlotMap<V> {
    private static final long serialVersionUID = -1609264341186593908L;
    private final TimeSlot timeSlot;
    private final int span;

    public MergeableTimeSlotMap(int span, TimeSlot timeSlot) {
        this(new ConcurrentHashMap<Instant, AtomicStampedReference<V>>(), span, timeSlot);
    }

    public MergeableTimeSlotMap(Map<Instant, AtomicStampedReference<V>> delegate, int span, TimeSlot timeSlot) {
        super(delegate);
        this.timeSlot = timeSlot;
        this.span = span;
    }

    public V merge(Instant ins, V newValue) {
        return (V)this.merge(ins, newValue, (current, update) -> current != null ? current.merge(update) : update);
    }

    @Override
    public Instant mutate(Object inputKey) {
        LocalDateTime ldt = this.timeSlot.locate((Instant)inputKey, this.span);
        return ldt.atZone(ZoneId.systemDefault()).toInstant();
    }

    @Override
    public Map<Instant, V> toMap() {
        return this.delegate.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(e -> (Instant)e.getKey(), e -> (MergeableFunction)((AtomicStampedReference)e.getValue()).getReference(), (o, n) -> o, LinkedHashMap::new));
    }

    public TimeSlot getTimeSlot() {
        return this.timeSlot;
    }

    public int getSpan() {
        return this.span;
    }
}

