/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.time;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.time.YearMonthUtils;
import java.time.Year;
import java.time.YearMonth;

public abstract class TimeAssert {
    public static void validateYear(int year) {
        Assert.outOfRange(year, 1970, 9999, "Out of year range. Input: " + year, new Object[0]);
    }

    public static void validateMonth(int month) {
        Assert.outOfRange(month, 1, 12, "Out of month range. Input: " + month, new Object[0]);
    }

    public static void validateDayOfYear(Year year, int dayOfYear) {
        Assert.outOfRange(dayOfYear, 1, year.isLeap() ? 366 : 365, "Out of day range of year: " + year + ". Input: " + dayOfYear, new Object[0]);
    }

    public static void validateDayOfMonth(YearMonth yearMonth, int dayOfMonth) {
        Assert.outOfRange(dayOfMonth, 1, yearMonth.atEndOfMonth().getDayOfMonth(), "Out of day range of month: " + yearMonth + ". Input: " + dayOfMonth, new Object[0]);
    }

    public static void validateDayOfMonth(int year, int month, int dayOfMonth) {
        TimeAssert.validateDayOfMonth(YearMonthUtils.of(year, month), dayOfMonth);
    }

    public static void validateTime(int hourOfDay, int minute, int second) {
        Assert.outOfRange(hourOfDay, 0, 23, "Out of hour range of a day. Input: " + hourOfDay, new Object[0]);
        Assert.outOfRange(minute, 0, 59, "Out of minute range of one hour. Input: " + minute, new Object[0]);
        Assert.outOfRange(second, 0, 59, "Out of second range of one minute. Input: " + second, new Object[0]);
    }

    public static void validateHourOfDay(int hourOfDay) {
        Assert.outOfRange(hourOfDay, 0, 23, "Out of hour range of a day. Input: " + hourOfDay, new Object[0]);
    }

    public static void validateMinuteOrSecond(int timeValue) {
        Assert.outOfRange(timeValue, 0, 59, "Out of time range of one minute or one second. Input: " + timeValue, new Object[0]);
    }
}

