/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.time;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.time.TimeAssert;
import com.github.paganini2008.devtools.time.YearUtils;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;

public abstract class YearMonthUtils {
    public static YearMonth toYearMonth(Year year, Month month) {
        Assert.outOfRange(year, YearUtils.MIN_YEAR, YearUtils.MAX_YEAR, "Out of year range. Input: " + year, new Object[0]);
        return year.atMonth(month);
    }

    public static YearMonth of(int year, int month) {
        TimeAssert.validateYear(year);
        TimeAssert.validateMonth(month);
        return YearMonth.of(year, month);
    }
}

