/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.parser;

import com.github.pagehelper.page.PageMethod;
import com.github.pagehelper.parser.CountSqlParser;
import com.github.pagehelper.parser.SqlParserUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.parser.Token;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.ParenthesedFromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.WithItem;

public class CountJSqlParser47
implements CountSqlParser {
    public static final String KEEP_ORDERBY = "/*keep orderby*/";
    protected static final Alias TABLE_ALIAS = new Alias("table_count");
    protected final Set<String> skipFunctions = Collections.synchronizedSet(new HashSet());
    protected final Set<String> falseFunctions = Collections.synchronizedSet(new HashSet());

    public String getSmartCountSql(String sql, String countColumn) {
        String hints;
        Token token;
        Statement stmt = null;
        if (sql.indexOf(KEEP_ORDERBY) >= 0 || this.keepOrderBy()) {
            return this.getSimpleCountSql(sql, countColumn);
        }
        try {
            stmt = SqlParserUtil.parse((String)sql);
        }
        catch (Throwable e) {
            return this.getSimpleCountSql(sql, countColumn);
        }
        Select select = (Select)stmt;
        try {
            this.processSelect(select);
        }
        catch (Exception e) {
            return this.getSimpleCountSql(sql, countColumn);
        }
        this.processWithItemsList(select.getWithItemsList());
        Select countSelect = this.sqlToCount(select, countColumn);
        String result = countSelect.toString();
        if (select instanceof PlainSelect && (token = select.getASTNode().jjtGetFirstToken().specialToken) != null && (hints = token.toString().trim()).startsWith("/*") && hints.endsWith("*/") && !result.startsWith("/*")) {
            result = hints + result;
        }
        return result;
    }

    public String getSimpleCountSql(String sql) {
        return this.getSimpleCountSql(sql, "0");
    }

    public String getSimpleCountSql(String sql, String name) {
        StringBuilder stringBuilder = new StringBuilder(sql.length() + 40);
        stringBuilder.append("select count(");
        stringBuilder.append(name);
        stringBuilder.append(") from ( \n");
        stringBuilder.append(sql);
        stringBuilder.append("\n ) tmp_count");
        return stringBuilder.toString();
    }

    public Select sqlToCount(Select select, String name) {
        ArrayList<SelectItem> COUNT_ITEM = new ArrayList<SelectItem>();
        COUNT_ITEM.add(new SelectItem((Expression)new Column("count(" + name + ")")));
        if (select instanceof PlainSelect && this.isSimpleCount((PlainSelect)select)) {
            ((PlainSelect)select).setSelectItems(COUNT_ITEM);
            return select;
        }
        PlainSelect plainSelect = new PlainSelect();
        ParenthesedSelect subSelect = new ParenthesedSelect();
        subSelect.setSelect(select);
        subSelect.setAlias(TABLE_ALIAS);
        plainSelect.setFromItem((FromItem)subSelect);
        plainSelect.setSelectItems(COUNT_ITEM);
        if (select.getWithItemsList() != null) {
            plainSelect.setWithItemsList(select.getWithItemsList());
            select.setWithItemsList(null);
        }
        return plainSelect;
    }

    public boolean isSimpleCount(PlainSelect select) {
        if (select.getGroupBy() != null) {
            return false;
        }
        if (select.getDistinct() != null) {
            return false;
        }
        if (select.getHaving() != null) {
            return false;
        }
        for (SelectItem item : select.getSelectItems()) {
            if (item.toString().contains("?")) {
                return false;
            }
            Expression expression = item.getExpression();
            if (expression instanceof Function) {
                String NAME;
                String name = ((Function)expression).getName();
                if (name == null || this.skipFunctions.contains(NAME = name.toUpperCase())) continue;
                if (this.falseFunctions.contains(NAME)) {
                    return false;
                }
                for (String aggregateFunction : AGGREGATE_FUNCTIONS) {
                    if (!NAME.startsWith(aggregateFunction)) continue;
                    this.falseFunctions.add(NAME);
                    return false;
                }
                this.skipFunctions.add(NAME);
                continue;
            }
            if (!(expression instanceof Parenthesis) || item.getAlias() == null) continue;
            return false;
        }
        return true;
    }

    public void processSelect(Select select) {
        if (select != null) {
            if (select instanceof PlainSelect) {
                this.processPlainSelect((PlainSelect)select);
            } else if (select instanceof ParenthesedSelect) {
                this.processSelect(((ParenthesedSelect)select).getSelect());
            } else if (select instanceof SetOperationList) {
                List selects = ((SetOperationList)select).getSelects();
                for (Select sel : selects) {
                    this.processSelect(sel);
                }
                if (!this.orderByHashParameters(select.getOrderByElements())) {
                    select.setOrderByElements(null);
                }
            }
        }
    }

    public void processPlainSelect(PlainSelect plainSelect) {
        if (!this.orderByHashParameters(plainSelect.getOrderByElements())) {
            plainSelect.setOrderByElements(null);
        }
        if (plainSelect.getFromItem() != null) {
            this.processFromItem(plainSelect.getFromItem());
        }
        if (plainSelect.getJoins() != null && plainSelect.getJoins().size() > 0) {
            List joins = plainSelect.getJoins();
            for (Join join : joins) {
                if (join.getRightItem() == null) continue;
                this.processFromItem(join.getRightItem());
            }
        }
    }

    public void processWithItemsList(List<WithItem> withItemsList) {
        if (withItemsList != null && !withItemsList.isEmpty()) {
            for (WithItem item : withItemsList) {
                if (item.getSelect() == null || this.keepSubSelectOrderBy()) continue;
                this.processSelect(item.getSelect());
            }
        }
    }

    public void processFromItem(FromItem fromItem) {
        if (fromItem instanceof ParenthesedSelect) {
            ParenthesedSelect parenthesedSelect = (ParenthesedSelect)fromItem;
            if (parenthesedSelect.getSelect() != null && !this.keepSubSelectOrderBy()) {
                this.processSelect(parenthesedSelect.getSelect());
            }
        } else if (fromItem instanceof Select) {
            this.processSelect((Select)fromItem);
        } else if (fromItem instanceof ParenthesedFromItem) {
            ParenthesedFromItem parenthesedFromItem = (ParenthesedFromItem)fromItem;
            this.processFromItem(parenthesedFromItem.getFromItem());
        }
    }

    protected boolean keepOrderBy() {
        return PageMethod.getLocalPage() != null && PageMethod.getLocalPage().keepOrderBy();
    }

    protected boolean keepSubSelectOrderBy() {
        return PageMethod.getLocalPage() != null && PageMethod.getLocalPage().keepSubSelectOrderBy();
    }

    public boolean orderByHashParameters(List<OrderByElement> orderByElements) {
        if (orderByElements == null) {
            return false;
        }
        for (OrderByElement orderByElement : orderByElements) {
            if (!orderByElement.toString().contains("?")) continue;
            return true;
        }
        return false;
    }

    static {
        TABLE_ALIAS.setUseAs(false);
    }
}

