/*
 * Decompiled with CFR 0.152.
 */
package org.iban4j;

import java.util.List;
import java.util.Random;
import org.iban4j.CountryCode;
import org.iban4j.IbanFormat;
import org.iban4j.IbanFormatException;
import org.iban4j.IbanUtil;
import org.iban4j.InvalidCheckDigitException;
import org.iban4j.UnsupportedCountryException;
import org.iban4j.bban.BbanStructure;
import org.iban4j.bban.BbanStructureEntry;

public final class Iban {
    static final String DEFAULT_CHECK_DIGIT = "00";
    private final String value;

    private Iban(String value) {
        this.value = value;
    }

    public CountryCode getCountryCode() {
        return CountryCode.getByCode(IbanUtil.getCountryCode(this.value));
    }

    public String getCheckDigit() {
        return IbanUtil.getCheckDigit(this.value);
    }

    public String getAccountNumber() {
        return IbanUtil.getAccountNumber(this.value);
    }

    public String getBankCode() {
        return IbanUtil.getBankCode(this.value);
    }

    public String getBranchCode() {
        return IbanUtil.getBranchCode(this.value);
    }

    public String getNationalCheckDigit() {
        return IbanUtil.getNationalCheckDigit(this.value);
    }

    public String getAccountType() {
        return IbanUtil.getAccountType(this.value);
    }

    public String getOwnerAccountType() {
        return IbanUtil.getOwnerAccountType(this.value);
    }

    public String getIdentificationNumber() {
        return IbanUtil.getIdentificationNumber(this.value);
    }

    public String getBban() {
        return IbanUtil.getBban(this.value);
    }

    public static Iban valueOf(String iban) throws IbanFormatException, InvalidCheckDigitException, UnsupportedCountryException {
        IbanUtil.validate(iban);
        return new Iban(iban);
    }

    public static Iban valueOf(String iban, IbanFormat format) throws IbanFormatException, InvalidCheckDigitException, UnsupportedCountryException {
        switch (format) {
            case Default: {
                String ibanWithoutSpaces = iban.replace(" ", "");
                Iban ibanObj = Iban.valueOf(ibanWithoutSpaces);
                if (ibanObj.toFormattedString().equals(iban)) {
                    return ibanObj;
                }
                throw new IbanFormatException(IbanFormatException.IbanFormatViolation.IBAN_FORMATTING, String.format("Iban must be formatted using 4 characters and space combination. Instead of [%s]", iban));
            }
        }
        return Iban.valueOf(iban);
    }

    public String toString() {
        return this.value;
    }

    public String toFormattedString() {
        return IbanUtil.toFormattedString(this.value);
    }

    public static Iban random() {
        return new Builder().buildRandom();
    }

    public static Iban random(CountryCode cc) {
        return new Builder().countryCode(cc).buildRandom();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Iban) {
            return this.value.equals(((Iban)obj).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public static final class Builder {
        private CountryCode countryCode;
        private String bankCode;
        private String branchCode;
        private String nationalCheckDigit;
        private String accountType;
        private String accountNumber;
        private String ownerAccountType;
        private String identificationNumber;
        private final Random random = new Random();

        public Builder countryCode(CountryCode countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder bankCode(String bankCode) {
            this.bankCode = bankCode;
            return this;
        }

        public Builder branchCode(String branchCode) {
            this.branchCode = branchCode;
            return this;
        }

        public Builder accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public Builder nationalCheckDigit(String nationalCheckDigit) {
            this.nationalCheckDigit = nationalCheckDigit;
            return this;
        }

        public Builder accountType(String accountType) {
            this.accountType = accountType;
            return this;
        }

        public Builder ownerAccountType(String ownerAccountType) {
            this.ownerAccountType = ownerAccountType;
            return this;
        }

        public Builder identificationNumber(String identificationNumber) {
            this.identificationNumber = identificationNumber;
            return this;
        }

        public Iban build() throws IbanFormatException, IllegalArgumentException, UnsupportedCountryException {
            return this.build(true);
        }

        public Iban build(boolean validate) throws IbanFormatException, IllegalArgumentException, UnsupportedCountryException {
            this.require(this.countryCode, this.bankCode, this.accountNumber);
            String formattedIban = this.formatIban();
            String checkDigit = IbanUtil.calculateCheckDigit(formattedIban);
            String ibanValue = IbanUtil.replaceCheckDigit(formattedIban, checkDigit);
            if (validate) {
                IbanUtil.validate(ibanValue);
            }
            return new Iban(ibanValue);
        }

        public Iban buildRandom() throws IbanFormatException, IllegalArgumentException, UnsupportedCountryException {
            if (this.countryCode == null) {
                List<CountryCode> countryCodes = BbanStructure.supportedCountries();
                this.countryCode(countryCodes.get(this.random.nextInt(countryCodes.size())));
            }
            this.fillMissingFieldsRandomly();
            return this.build();
        }

        private String formatBban() {
            StringBuilder sb = new StringBuilder();
            BbanStructure structure = BbanStructure.forCountry(this.countryCode);
            if (structure == null) {
                throw new UnsupportedCountryException(this.countryCode.toString(), "Country code is not supported.");
            }
            for (BbanStructureEntry entry : structure.getEntries()) {
                switch (entry.getEntryType()) {
                    case bank_code: {
                        sb.append(this.bankCode);
                        break;
                    }
                    case branch_code: {
                        sb.append(this.branchCode);
                        break;
                    }
                    case account_number: {
                        sb.append(this.accountNumber);
                        break;
                    }
                    case national_check_digit: {
                        sb.append(this.nationalCheckDigit);
                        break;
                    }
                    case account_type: {
                        sb.append(this.accountType);
                        break;
                    }
                    case owner_account_number: {
                        sb.append(this.ownerAccountType);
                        break;
                    }
                    case identification_number: {
                        sb.append(this.identificationNumber);
                    }
                }
            }
            return sb.toString();
        }

        private String formatIban() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.countryCode.getAlpha2());
            sb.append(Iban.DEFAULT_CHECK_DIGIT);
            sb.append(this.formatBban());
            return sb.toString();
        }

        private void require(CountryCode countryCode, String bankCode, String accountNumber) throws IbanFormatException {
            if (countryCode == null) {
                throw new IbanFormatException(IbanFormatException.IbanFormatViolation.COUNTRY_CODE_NOT_NULL, "countryCode is required; it cannot be null");
            }
            if (bankCode == null) {
                throw new IbanFormatException(IbanFormatException.IbanFormatViolation.BANK_CODE_NOT_NULL, "bankCode is required; it cannot be null");
            }
            if (accountNumber == null) {
                throw new IbanFormatException(IbanFormatException.IbanFormatViolation.ACCOUNT_NUMBER_NOT_NULL, "accountNumber is required; it cannot be null");
            }
        }

        private void fillMissingFieldsRandomly() {
            BbanStructure structure = BbanStructure.forCountry(this.countryCode);
            if (structure == null) {
                throw new UnsupportedCountryException(this.countryCode.toString(), "Country code is not supported.");
            }
            for (BbanStructureEntry entry : structure.getEntries()) {
                switch (entry.getEntryType()) {
                    case bank_code: {
                        if (this.bankCode != null) break;
                        this.bankCode = entry.getRandom();
                        break;
                    }
                    case branch_code: {
                        if (this.branchCode != null) break;
                        this.branchCode = entry.getRandom();
                        break;
                    }
                    case account_number: {
                        if (this.accountNumber != null) break;
                        this.accountNumber = entry.getRandom();
                        break;
                    }
                    case national_check_digit: {
                        if (this.nationalCheckDigit != null) break;
                        this.nationalCheckDigit = entry.getRandom();
                        break;
                    }
                    case account_type: {
                        if (this.accountType != null) break;
                        this.accountType = entry.getRandom();
                        break;
                    }
                    case owner_account_number: {
                        if (this.ownerAccountType != null) break;
                        this.ownerAccountType = entry.getRandom();
                        break;
                    }
                    case identification_number: {
                        if (this.identificationNumber != null) break;
                        this.identificationNumber = entry.getRandom();
                    }
                }
            }
        }
    }
}

