/*
 * Decompiled with CFR 0.152.
 */
package org.iban4j.bban;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.iban4j.bban.BbanEntryType;

public class BbanStructureEntry {
    private final BbanEntryType entryType;
    private final EntryCharacterType characterType;
    private final int length;
    private static Map<EntryCharacterType, char[]> charByCharacterType = new HashMap<EntryCharacterType, char[]>();
    private final Random random = new Random();

    private BbanStructureEntry(BbanEntryType entryType, EntryCharacterType characterType, int length) {
        this.entryType = entryType;
        this.characterType = characterType;
        this.length = length;
    }

    public static BbanStructureEntry bankCode(int length, char characterType) {
        return new BbanStructureEntry(BbanEntryType.bank_code, EntryCharacterType.valueOf(String.valueOf(characterType)), length);
    }

    public static BbanStructureEntry branchCode(int length, char characterType) {
        return new BbanStructureEntry(BbanEntryType.branch_code, EntryCharacterType.valueOf(String.valueOf(characterType)), length);
    }

    public static BbanStructureEntry accountNumber(int length, char characterType) {
        return new BbanStructureEntry(BbanEntryType.account_number, EntryCharacterType.valueOf(String.valueOf(characterType)), length);
    }

    public static BbanStructureEntry nationalCheckDigit(int length, char characterType) {
        return new BbanStructureEntry(BbanEntryType.national_check_digit, EntryCharacterType.valueOf(String.valueOf(characterType)), length);
    }

    public static BbanStructureEntry accountType(int length, char characterType) {
        return new BbanStructureEntry(BbanEntryType.account_type, EntryCharacterType.valueOf(String.valueOf(characterType)), length);
    }

    public static BbanStructureEntry ownerAccountNumber(int length, char characterType) {
        return new BbanStructureEntry(BbanEntryType.owner_account_number, EntryCharacterType.valueOf(String.valueOf(characterType)), length);
    }

    public static BbanStructureEntry identificationNumber(int length, char characterType) {
        return new BbanStructureEntry(BbanEntryType.identification_number, EntryCharacterType.valueOf(String.valueOf(characterType)), length);
    }

    public BbanEntryType getEntryType() {
        return this.entryType;
    }

    public EntryCharacterType getCharacterType() {
        return this.characterType;
    }

    public int getLength() {
        return this.length;
    }

    public String getRandom() {
        StringBuilder s = new StringBuilder("");
        char[] charChoices = charByCharacterType.get((Object)this.characterType);
        if (charChoices == null) {
            throw new RuntimeException(String.format("programmer has not implemented choices for character type %s", this.characterType.name()));
        }
        for (int i = 0; i < this.getLength(); ++i) {
            s.append(charChoices[this.random.nextInt(charChoices.length)]);
        }
        return s.toString();
    }

    static {
        StringBuilder charTypeN = new StringBuilder();
        for (char ch = '0'; ch <= '9'; ch = (char)(ch + '\u0001')) {
            charTypeN.append(ch);
        }
        charByCharacterType.put(EntryCharacterType.n, charTypeN.toString().toCharArray());
        StringBuilder charTypeA = new StringBuilder();
        for (char ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            charTypeA.append(ch);
        }
        charByCharacterType.put(EntryCharacterType.a, charTypeA.toString().toCharArray());
        charByCharacterType.put(EntryCharacterType.c, (charTypeN.toString() + charTypeA.toString()).toCharArray());
    }

    public static enum EntryCharacterType {
        n,
        a,
        c;

    }
}

