/*
 * Decompiled with CFR 0.152.
 */
package better.files;

import better.files.Dsl;
import better.files.File;
import better.files.File$;
import better.files.File$CopyOptions$;
import better.files.package$;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.Instant;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.UninitializedFieldError;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;

public final class Dsl$ {
    public static final Dsl$ MODULE$;
    private final Function1<File, File> $u002E$u002E;
    private final Function1<File, File> $u002E;
    private volatile byte bitmap$init$0;

    static {
        new Dsl$();
    }

    public File $tilde() {
        return File$.MODULE$.home();
    }

    public File pwd() {
        return File$.MODULE$.currentWorkingDirectory();
    }

    public File cwd() {
        return this.pwd();
    }

    public Function1<File, File> $u002E$u002E() {
        if ((byte)(this.bitmap$init$0 & 1) != 0) {
            return this.$u002E$u002E;
        }
        throw new UninitializedFieldError("Uninitialized field: Dsl.scala: 20");
    }

    public Function1<File, File> $u002E() {
        if ((byte)(this.bitmap$init$0 & 2) != 0) {
            return this.$u002E;
        }
        throw new UninitializedFieldError("Uninitialized field: Dsl.scala: 23");
    }

    public Dsl.SymbolicOperations SymbolicOperations(File file) {
        return new Dsl.SymbolicOperations(file);
    }

    public File cp(File from, File to) {
        File file;
        if (to.isDirectory(to.isDirectory$default$1())) {
            File x$3 = to;
            Seq<LinkOption> x$4 = from.copyToDirectory$default$2(x$3);
            Seq<CopyOption> x$5 = from.copyToDirectory$default$3(x$3);
            file = from.copyToDirectory(x$3, x$4, x$5);
        } else {
            File x$6 = to;
            boolean x$7 = true;
            Seq<CopyOption> x$8 = from.copyTo$default$3(x$6, x$7);
            file = from.copyTo(x$6, x$7, x$8);
        }
        return file;
    }

    public File mv(File from, File to) {
        File file;
        if (to.isDirectory(to.isDirectory$default$1())) {
            File x$9 = to;
            Seq<LinkOption> x$10 = from.moveToDirectory$default$2(x$9);
            file = from.moveToDirectory(x$9, x$10);
        } else {
            file = from.moveTo(to, File$CopyOptions$.MODULE$.apply(true));
        }
        return file;
    }

    public File rm(File file) {
        return file.delete(true, file.delete$default$2());
    }

    public File del(File file) {
        return this.rm(file);
    }

    public File ln(File file1, File file2) {
        File x$11 = file2;
        boolean x$12 = file1.linkTo$default$2();
        Seq<FileAttribute<?>> x$13 = file1.linkTo$default$3(x$11, x$12);
        return file1.linkTo(x$11, x$12, x$13);
    }

    public File ln_s(File file1, File file2) {
        File x$14 = file2;
        Seq<FileAttribute<?>> x$15 = file1.symbolicLinkTo$default$2(x$14);
        return file1.symbolicLinkTo(x$14, x$15);
    }

    public Seq<Iterator<Object>> cat(Seq<File> files) {
        return (Seq)files.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<Object> apply(File x$2) {
                return x$2.bytes();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Iterator<File> ls(File file) {
        return file.list();
    }

    public Iterator<File> dir(File file) {
        return this.ls(file);
    }

    public Iterator<File> ls_r(File file) {
        return file.listRecursively(file.listRecursively$default$1());
    }

    public File touch(File file) {
        Instant x$16 = file.touch$default$1();
        Seq<FileAttribute<?>> x$17 = file.touch$default$2(x$16);
        Seq<LinkOption> x$18 = file.touch$default$3(x$16);
        return file.touch(x$16, x$17, x$18);
    }

    public File mkdir(File file) {
        return file.createDirectory(file.createDirectory$default$1());
    }

    public String md5(File file) {
        return file.md5();
    }

    public String sha1(File file) {
        return file.sha1();
    }

    public String sha256(File file) {
        return file.sha256();
    }

    public String sha512(File file) {
        return file.sha512();
    }

    public File mkdirs(File file) {
        return file.createDirectories(file.createDirectories$default$1(), file.createDirectories$default$2());
    }

    public File chown(String owner, File file) {
        return file.setOwner(owner);
    }

    public File chgrp(String group, File file) {
        String x$19 = group;
        Seq<LinkOption> x$20 = file.setGroup$default$2(x$19);
        return file.setGroup(x$19, x$20);
    }

    public File chmod(String permissions, File file) {
        return file.setPermissions((Set<PosixFilePermission>)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(PosixFilePermissions.fromString(permissions)).asScala()).toSet());
    }

    public File chmod_$plus(PosixFilePermission permission, File file) {
        PosixFilePermission x$21 = permission;
        Seq<LinkOption> x$22 = file.addPermission$default$2(x$21);
        return file.addPermission(x$21, x$22);
    }

    public File chmod_$minus(PosixFilePermission permission, File file) {
        PosixFilePermission x$23 = permission;
        Seq<LinkOption> x$24 = file.removePermission$default$2(x$23);
        return file.removePermission(x$23, x$24);
    }

    public PosixFileAttributes stat(File file) {
        return file.posixAttributes(file.posixAttributes$default$1());
    }

    public File unzip(File zipFile, File destination, Charset charset) {
        return zipFile.unzipTo(destination, zipFile.unzipTo$default$2(), charset);
    }

    public Charset unzip$default$3(File zipFile, File destination) {
        return package$.MODULE$.DefaultCharset();
    }

    public File zip(Seq<File> files, File destination, int compressionLevel, Charset charset) {
        return destination.zipIn((Iterator<File>)files.iterator(), compressionLevel, charset);
    }

    public int zip$default$3(Seq<File> files) {
        return -1;
    }

    public Charset zip$default$4(Seq<File> files, File destination, int compressionLevel) {
        return package$.MODULE$.DefaultCharset();
    }

    public File ungzip(File gzipFile, File destination) {
        return gzipFile.unGzipTo(destination, gzipFile.unGzipTo$default$2(), gzipFile.unGzipTo$default$3());
    }

    public File gzip(File file, File destination) {
        return file.gzipTo(destination, file.gzipTo$default$2(), file.gzipTo$default$3(), file.gzipTo$default$4());
    }

    private Dsl$() {
        MODULE$ = this;
        this.$u002E$u002E = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(File x$1) {
                return x$1.parent();
            }
        };
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.$u002E = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(File x) {
                return (File)Predef$.MODULE$.identity((Object)x);
            }
        };
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

