/*
 * Decompiled with CFR 0.152.
 */
package better.files;

import better.files.File;
import better.files.File$Attributes$;
import better.files.UnicodeCharset$;
import better.files.package$;
import com.sun.management.UnixOperatingSystemMXBean;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.reflect.ClassTag$;
import scala.util.Properties$;

public final class File$ {
    public static File$ MODULE$;
    private final Charset defaultCharset;

    static {
        new File$();
    }

    public Charset defaultCharset() {
        return this.defaultCharset;
    }

    public File resource(String name) {
        return this.apply(package$.MODULE$.currentClassLoader().getResource(name));
    }

    public File copyResource(String name, File out) {
        package$.MODULE$.InputStreamOps(package$.MODULE$.resourceAsStream(name)).$greater(out.newOutputStream(out.newOutputStream$default$1()));
        return out;
    }

    public File copyResource$default$2(String name) {
        String x$49 = name;
        String x$50 = this.newTemporaryFile$default$2();
        Option<File> x$51 = this.newTemporaryFile$default$3();
        Seq<FileAttribute<?>> x$52 = this.newTemporaryFile$default$4(x$49, x$50, x$51);
        return this.newTemporaryFile(x$49, x$50, x$51, x$52);
    }

    public File newTemporaryDirectory(String prefix, Option<File> parent, Seq<FileAttribute<?>> attributes) {
        File file;
        Option<File> option = parent;
        if (option instanceof Some) {
            Some some = (Some)option;
            File dir = (File)some.value();
            file = this.apply(Files.createTempDirectory(dir.path(), prefix, (FileAttribute[])attributes.toArray(ClassTag$.MODULE$.apply(FileAttribute.class))));
        } else {
            file = this.apply(Files.createTempDirectory(prefix, (FileAttribute[])attributes.toArray(ClassTag$.MODULE$.apply(FileAttribute.class))));
        }
        return file;
    }

    public String newTemporaryDirectory$default$1() {
        return "";
    }

    public Option<File> newTemporaryDirectory$default$2() {
        return None$.MODULE$;
    }

    public Seq<FileAttribute<?>> newTemporaryDirectory$default$3(String prefix, Option<File> parent) {
        return File$Attributes$.MODULE$.default();
    }

    public <U> U usingTemporaryDirectory(String prefix, Option<File> parent, Seq<FileAttribute<?>> attributes, Function1<File, U> f) {
        return this.newTemporaryDirectory(prefix, parent, attributes).applyAndDelete(f);
    }

    public <U> String usingTemporaryDirectory$default$1() {
        return "";
    }

    public <U> Option<File> usingTemporaryDirectory$default$2() {
        return None$.MODULE$;
    }

    public <U> Seq<FileAttribute<?>> usingTemporaryDirectory$default$3() {
        return File$Attributes$.MODULE$.default();
    }

    public File newTemporaryFile(String prefix, String suffix, Option<File> parent, Seq<FileAttribute<?>> attributes) {
        File file;
        Option<File> option = parent;
        if (option instanceof Some) {
            Some some = (Some)option;
            File dir = (File)some.value();
            file = this.apply(Files.createTempFile(dir.path(), prefix, suffix, (FileAttribute[])attributes.toArray(ClassTag$.MODULE$.apply(FileAttribute.class))));
        } else {
            file = this.apply(Files.createTempFile(prefix, suffix, (FileAttribute[])attributes.toArray(ClassTag$.MODULE$.apply(FileAttribute.class))));
        }
        return file;
    }

    public String newTemporaryFile$default$1() {
        return "";
    }

    public String newTemporaryFile$default$2() {
        return "";
    }

    public Option<File> newTemporaryFile$default$3() {
        return None$.MODULE$;
    }

    public Seq<FileAttribute<?>> newTemporaryFile$default$4(String prefix, String suffix, Option<File> parent) {
        return File$Attributes$.MODULE$.default();
    }

    public <U> U usingTemporaryFile(String prefix, String suffix, Option<File> parent, Seq<FileAttribute<?>> attributes, Function1<File, U> f) {
        return this.newTemporaryFile(prefix, suffix, parent, attributes).applyAndDelete(f);
    }

    public <U> String usingTemporaryFile$default$1() {
        return "";
    }

    public <U> String usingTemporaryFile$default$2() {
        return "";
    }

    public <U> Option<File> usingTemporaryFile$default$3() {
        return None$.MODULE$;
    }

    public <U> Seq<FileAttribute<?>> usingTemporaryFile$default$4() {
        return File$Attributes$.MODULE$.default();
    }

    public File apply(Path path) {
        return new File(path.toAbsolutePath().normalize());
    }

    public File apply(String path, Seq<String> fragments) {
        return this.apply(Paths.get(path, (String[])fragments.toArray(ClassTag$.MODULE$.apply(String.class))));
    }

    public File apply(File anchor, String path, Seq<String> fragments) {
        Path p = Paths.get(path, (String[])fragments.toArray(ClassTag$.MODULE$.apply(String.class)));
        return p.isAbsolute() ? this.apply(p) : (anchor.isDirectory(anchor.isDirectory$default$1()) ? anchor.$div(((Object)p).toString()) : anchor.parent().$div(((Object)p).toString()));
    }

    public File apply(URL url) {
        return this.apply(url.toURI());
    }

    public File apply(URI uri) {
        return this.apply(Paths.get(uri));
    }

    public Iterable<File> roots() {
        return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(FileSystems.getDefault().getRootDirectories()).asScala()).map((Function1 & Serializable & scala.Serializable)path -> MODULE$.apply((Path)path), Iterable$.MODULE$.canBuildFrom());
    }

    public File root() {
        return (File)this.roots().head();
    }

    public File home() {
        return package$.MODULE$.StringOps(Properties$.MODULE$.userHome()).toFile();
    }

    public File temp() {
        return package$.MODULE$.StringOps(Properties$.MODULE$.tmpDir()).toFile();
    }

    public File currentWorkingDirectory() {
        return this.apply("", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    public long numberOfOpenFileDescriptors() {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (!(operatingSystemMXBean instanceof UnixOperatingSystemMXBean)) {
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported operating system: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operatingSystemMXBean})));
        }
        UnixOperatingSystemMXBean unixOperatingSystemMXBean = (UnixOperatingSystemMXBean)operatingSystemMXBean;
        long l = unixOperatingSystemMXBean.getMaxFileDescriptorCount();
        return l;
    }

    private File$() {
        MODULE$ = this;
        this.defaultCharset = UnicodeCharset$.MODULE$.apply(Charset.defaultCharset(), UnicodeCharset$.MODULE$.apply$default$2());
    }
}

