/*
 * Decompiled with CFR 0.152.
 */
package better.files;

import better.files.Dispose;
import better.files.File;
import better.files.File$Attributes$;
import better.files.package$;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.management.ObjectName;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Properties$;

public final class File$
implements scala.Serializable {
    public static File$ MODULE$;

    static {
        new File$();
    }

    private FileSystem $lessinit$greater$default$2(Path path) {
        return path.getFileSystem();
    }

    public File newTemporaryDirectory(String prefix, Option<File> parent, Seq<FileAttribute<?>> attributes) {
        File file;
        Option<File> option = parent;
        if (option instanceof Some) {
            Some some = (Some)option;
            File dir = (File)some.value();
            file = this.apply(Files.createTempDirectory(dir.path(), prefix, (FileAttribute[])attributes.toArray(ClassTag$.MODULE$.apply(FileAttribute.class))));
        } else {
            file = this.apply(Files.createTempDirectory(prefix, (FileAttribute[])attributes.toArray(ClassTag$.MODULE$.apply(FileAttribute.class))));
        }
        return file;
    }

    public String newTemporaryDirectory$default$1() {
        return "";
    }

    public Option<File> newTemporaryDirectory$default$2() {
        return None$.MODULE$;
    }

    public Seq<FileAttribute<?>> newTemporaryDirectory$default$3(String prefix, Option<File> parent) {
        return File$Attributes$.MODULE$.default();
    }

    public Dispose<File> temporaryDirectory(String prefix, Option<File> parent, Seq<FileAttribute<?>> attributes) {
        return this.newTemporaryDirectory(prefix, parent, attributes).toTemporary();
    }

    public <U> void usingTemporaryDirectory(String prefix, Option<File> parent, Seq<FileAttribute<?>> attributes, Function1<File, U> f) {
        this.temporaryDirectory(prefix, parent, attributes).foreach(f);
    }

    public <U> String usingTemporaryDirectory$default$1() {
        return "";
    }

    public <U> Option<File> usingTemporaryDirectory$default$2() {
        return None$.MODULE$;
    }

    public <U> Seq<FileAttribute<?>> usingTemporaryDirectory$default$3() {
        return File$Attributes$.MODULE$.default();
    }

    public File newTemporaryFile(String prefix, String suffix, Option<File> parent, Seq<FileAttribute<?>> attributes) {
        File file;
        Option<File> option = parent;
        if (option instanceof Some) {
            Some some = (Some)option;
            File dir = (File)some.value();
            file = this.apply(Files.createTempFile(dir.path(), prefix, suffix, (FileAttribute[])attributes.toArray(ClassTag$.MODULE$.apply(FileAttribute.class))));
        } else {
            file = this.apply(Files.createTempFile(prefix, suffix, (FileAttribute[])attributes.toArray(ClassTag$.MODULE$.apply(FileAttribute.class))));
        }
        return file;
    }

    public String newTemporaryFile$default$1() {
        return "";
    }

    public String newTemporaryFile$default$2() {
        return "";
    }

    public Option<File> newTemporaryFile$default$3() {
        return None$.MODULE$;
    }

    public Seq<FileAttribute<?>> newTemporaryFile$default$4(String prefix, String suffix, Option<File> parent) {
        return File$Attributes$.MODULE$.default();
    }

    public <U> Dispose<File> temporaryFile(String prefix, String suffix, Option<File> parent, Seq<FileAttribute<?>> attributes) {
        return this.newTemporaryFile(prefix, suffix, parent, attributes).toTemporary();
    }

    public <U> void usingTemporaryFile(String prefix, String suffix, Option<File> parent, Seq<FileAttribute<?>> attributes, Function1<File, U> f) {
        this.temporaryFile(prefix, suffix, parent, attributes).foreach(f);
    }

    public <U> String usingTemporaryFile$default$1() {
        return "";
    }

    public <U> String usingTemporaryFile$default$2() {
        return "";
    }

    public <U> Option<File> usingTemporaryFile$default$3() {
        return None$.MODULE$;
    }

    public <U> Seq<FileAttribute<?>> usingTemporaryFile$default$4() {
        return File$Attributes$.MODULE$.default();
    }

    public File apply(Path path) {
        Path x$1 = path.toAbsolutePath().normalize();
        FileSystem x$2 = this.$lessinit$greater$default$2(x$1);
        return new File(x$1, x$2);
    }

    public File apply(String path, Seq<String> fragments) {
        return this.apply(Paths.get(path, (String[])fragments.toArray(ClassTag$.MODULE$.apply(String.class))));
    }

    public File apply(File anchor, String path, Seq<String> fragments) {
        Path p = Paths.get(path, (String[])fragments.toArray(ClassTag$.MODULE$.apply(String.class)));
        return p.isAbsolute() ? this.apply(p) : (anchor.isDirectory(anchor.isDirectory$default$1()) ? anchor.$div(((Object)p).toString()) : anchor.parent().$div(((Object)p).toString()));
    }

    public File apply(URL url) {
        return this.apply(url.toURI());
    }

    public File apply(URI uri) {
        return this.apply(Paths.get(uri));
    }

    public Iterable<File> roots() {
        return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(FileSystems.getDefault().getRootDirectories()).asScala()).map((Function1 & Serializable & scala.Serializable)path -> MODULE$.apply((Path)path), Iterable$.MODULE$.canBuildFrom());
    }

    public File root() {
        return (File)this.roots().head();
    }

    public File home() {
        return package$.MODULE$.StringOps(Properties$.MODULE$.userHome()).toFile();
    }

    public File temp() {
        return package$.MODULE$.StringOps(Properties$.MODULE$.tmpDir()).toFile();
    }

    public String temporaryDirectory$default$1() {
        return "";
    }

    public Option<File> temporaryDirectory$default$2() {
        return None$.MODULE$;
    }

    public Seq<FileAttribute<?>> temporaryDirectory$default$3() {
        return File$Attributes$.MODULE$.default();
    }

    public <U> String temporaryFile$default$1() {
        return "";
    }

    public <U> String temporaryFile$default$2() {
        return "";
    }

    public <U> Option<File> temporaryFile$default$3() {
        return None$.MODULE$;
    }

    public <U> Seq<FileAttribute<?>> temporaryFile$default$4() {
        return File$Attributes$.MODULE$.default();
    }

    public File currentWorkingDirectory() {
        return this.apply("", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    public long numberOfOpenFileDescriptors() {
        return BoxesRunTime.unboxToLong((Object)ManagementFactory.getPlatformMBeanServer().getAttribute(new ObjectName("java.lang:type=OperatingSystem"), "OpenFileDescriptorCount"));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private File$() {
        MODULE$ = this;
    }
}

