/*
 * Decompiled with CFR 0.152.
 */
package better.files;

import better.files.Dsl;
import better.files.File;
import better.files.File$;
import better.files.File$CopyOptions$;
import better.files.package$;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.Instant;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;

public final class Dsl$ {
    public static final Dsl$ MODULE$ = new Dsl$();
    private static final Function1<File, File> $u002E$u002E = (Function1 & Serializable)x$1 -> x$1.parent();
    private static final Function1<File, File> $u002E = (Function1 & Serializable)x -> (File)Predef$.MODULE$.identity(x);

    public File $tilde() {
        return File$.MODULE$.home();
    }

    public File pwd() {
        return File$.MODULE$.currentWorkingDirectory();
    }

    public File cwd() {
        return this.pwd();
    }

    public Function1<File, File> $u002E$u002E() {
        return $u002E$u002E;
    }

    public Function1<File, File> $u002E() {
        return $u002E;
    }

    public Dsl.SymbolicOperations SymbolicOperations(File file) {
        return new Dsl.SymbolicOperations(file);
    }

    public File cp(File from, File to) {
        if (to.isDirectory(to.isDirectory$default$1())) {
            File x$1 = to;
            Seq<LinkOption> x$2 = from.copyToDirectory$default$2(x$1);
            Seq<CopyOption> x$3 = from.copyToDirectory$default$3(x$1);
            return from.copyToDirectory(x$1, x$2, x$3);
        }
        File x$4 = to;
        boolean x$5 = true;
        Seq<CopyOption> x$6 = from.copyTo$default$3(x$4, true);
        return from.copyTo(x$4, true, x$6);
    }

    public File mv(File from, File to) {
        if (to.isDirectory(to.isDirectory$default$1())) {
            File x$1 = to;
            Seq<LinkOption> x$2 = from.moveToDirectory$default$2(x$1);
            return from.moveToDirectory(x$1, x$2);
        }
        return from.moveTo(to, File$CopyOptions$.MODULE$.apply(true));
    }

    public File rm(File file) {
        return file.delete(true, file.delete$default$2());
    }

    public File del(File file) {
        return this.rm(file);
    }

    public File ln(File file1, File file2) {
        File x$1 = file2;
        boolean x$2 = file1.linkTo$default$2();
        Seq<FileAttribute<?>> x$3 = file1.linkTo$default$3(x$1, x$2);
        return file1.linkTo(x$1, x$2, x$3);
    }

    public File ln_s(File file1, File file2) {
        File x$1 = file2;
        Seq<FileAttribute<?>> x$2 = file1.symbolicLinkTo$default$2(x$1);
        return file1.symbolicLinkTo(x$1, x$2);
    }

    public Seq<Iterator<Object>> cat(Seq<File> files) {
        return (Seq)files.map((Function1 & Serializable)x$2 -> x$2.bytes());
    }

    public Iterator<File> ls(File file) {
        return file.list();
    }

    public Iterator<File> dir(File file) {
        return this.ls(file);
    }

    public Iterator<File> ls_r(File file) {
        return file.listRecursively(file.listRecursively$default$1());
    }

    public File touch(File file) {
        Instant x$1 = file.touch$default$1();
        Seq<FileAttribute<?>> x$2 = file.touch$default$2(x$1);
        Seq<LinkOption> x$3 = file.touch$default$3(x$1);
        return file.touch(x$1, x$2, x$3);
    }

    public File mkdir(File file) {
        return file.createDirectory(file.createDirectory$default$1());
    }

    public String md5(File file) {
        return file.md5();
    }

    public String sha1(File file) {
        return file.sha1();
    }

    public String sha256(File file) {
        return file.sha256();
    }

    public String sha512(File file) {
        return file.sha512();
    }

    public File mkdirs(File file) {
        return file.createDirectories(file.createDirectories$default$1(), file.createDirectories$default$2());
    }

    public File chown(String owner, File file) {
        return file.setOwner(owner);
    }

    public File chgrp(String group, File file) {
        String x$1 = group;
        Seq<LinkOption> x$2 = file.setGroup$default$2(x$1);
        return file.setGroup(x$1, x$2);
    }

    public File chmod(String permissions, File file) {
        return file.setPermissions((Set<PosixFilePermission>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(PosixFilePermissions.fromString(permissions)).asScala()).toSet());
    }

    public File chmod_$plus(PosixFilePermission permission, File file) {
        PosixFilePermission x$1 = permission;
        Seq<LinkOption> x$2 = file.addPermission$default$2(x$1);
        return file.addPermission(x$1, x$2);
    }

    public File chmod_$minus(PosixFilePermission permission, File file) {
        PosixFilePermission x$1 = permission;
        Seq<LinkOption> x$2 = file.removePermission$default$2(x$1);
        return file.removePermission(x$1, x$2);
    }

    public PosixFileAttributes stat(File file) {
        return file.posixAttributes(file.posixAttributes$default$1());
    }

    public File unzip(File zipFile, File destination, Charset charset) {
        return zipFile.unzipTo(destination, zipFile.unzipTo$default$2(), charset);
    }

    public Charset unzip$default$3(File zipFile, File destination) {
        return package$.MODULE$.DefaultCharset();
    }

    public File zip(Seq<File> files, File destination, int compressionLevel, Charset charset) {
        return destination.zipIn((Iterator<File>)files.iterator(), compressionLevel, charset);
    }

    public int zip$default$3(Seq<File> files) {
        return -1;
    }

    public Charset zip$default$4(Seq<File> files, File destination, int compressionLevel) {
        return package$.MODULE$.DefaultCharset();
    }

    public File ungzip(File gzipFile, File destination) {
        return gzipFile.unGzipTo(destination, gzipFile.unGzipTo$default$2(), gzipFile.unGzipTo$default$3());
    }

    public File gzip(File file, File destination) {
        return file.gzipTo(destination, file.gzipTo$default$2(), file.gzipTo$default$3(), file.gzipTo$default$4());
    }

    private Dsl$() {
    }
}

