/*
 * Decompiled with CFR 0.152.
 */
package com.github.patricio78.liquibase.kubernetes;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.util.Config;
import java.io.IOException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KubernetesConnector {
    private static final Log LOG = LogFactory.getLog(KubernetesConnector.class);
    public static final String POD_PHASE_PENDING = "Pending";
    public static final String POD_PHASE_RUNNING = "Running";
    public static final int HTTP_STATUS_NOT_FOUND = 404;
    private final boolean connected;
    private final String podName = System.getenv().get("POD_NAME");
    private final String podNamespace = System.getenv().get("POD_NAMESPACE");

    public static KubernetesConnector getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private KubernetesConnector() {
        if (StringUtils.isNotBlank((CharSequence)this.podName) && StringUtils.isNotBlank((CharSequence)this.podNamespace)) {
            this.connected = this.connect();
        } else {
            this.connected = false;
            LOG.debug((Object)"POD_NAME or POD_NAMESPACE is not configured, Liquibase - Kubernetes integration disabled");
        }
    }

    private boolean connect() {
        try {
            LOG.trace((Object)"Create client with from cluster configuration");
            ApiClient client = Config.fromCluster();
            Configuration.setDefaultApiClient((ApiClient)client);
            LOG.trace((Object)("BasePath: " + client.getBasePath()));
            LOG.trace((Object)("Authentication: " + client.getAuthentications().entrySet().stream().map(entry -> (String)entry.getKey() + ":" + entry.getValue()).collect(Collectors.joining(", "))));
            CoreV1Api api = new CoreV1Api();
            LOG.trace((Object)("Reading pod status, Pod name: " + this.podName + " Pod namespace: " + this.podNamespace));
            V1Pod pod = api.readNamespacedPodStatus(this.podName, this.podNamespace, "true");
            String podPhase = pod.getStatus().getPhase();
            LOG.trace((Object)("Pod phase:" + podPhase));
            LOG.trace((Object)"Connected to Kubernetes using fromCluster configuration");
            return true;
        }
        catch (ApiException | IOException e) {
            LOG.debug((Object)"Connection fail to Kubernetes cluster using fromCluster configuration");
            LOG.trace((Object)"Pod status read error", e);
            return false;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getPodName() {
        return this.podName;
    }

    public String getPodNamespace() {
        return this.podNamespace;
    }

    public boolean isCurrentPod(String podNamespace, String podName) {
        if (podNamespace == null || podName == null) {
            return false;
        }
        return podNamespace.equals(this.podNamespace) && podName.equals(this.podName);
    }

    public Boolean isPodActive(String podNamespace, String podName) {
        try {
            CoreV1Api api = new CoreV1Api();
            LOG.trace((Object)("Reading pod status, Pod name: " + podName + " Pod namespace: " + podNamespace));
            V1Pod pod = null;
            pod = api.readNamespacedPodStatus(podName, podNamespace, "true");
            String podPhase = pod.getStatus().getPhase();
            if (POD_PHASE_PENDING.equals(podPhase) || POD_PHASE_RUNNING.equals(podPhase)) {
                LOG.trace((Object)("Pod is active, phase:" + podPhase));
                return true;
            }
            LOG.trace((Object)("Pod is inactive, phase:" + podPhase));
            return false;
        }
        catch (ApiException e) {
            if (e.getCode() == 404) {
                LOG.trace((Object)"Can't find pod");
                return false;
            }
            LOG.debug((Object)("Can't read Pod status:" + podNamespace + ":" + podName));
            LOG.trace((Object)"Pod status read error", (Throwable)e);
            return null;
        }
    }

    public static final class InstanceHolder {
        private static final KubernetesConnector INSTANCE = new KubernetesConnector();
    }
}

