/*
 * Decompiled with CFR 0.152.
 */
package com.github.patricio78.liquibase.kubernetes;

import com.github.patricio78.liquibase.kubernetes.KubernetesConnector;
import java.util.StringTokenizer;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LockException;
import liquibase.executor.ExecutorService;
import liquibase.lockservice.StandardLockService;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.SelectFromDatabaseChangeLogLockStatement;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KubernetesLockService
extends StandardLockService {
    private static final Log LOG = LogFactory.getLog(KubernetesLockService.class);

    public int getPriority() {
        return 1000;
    }

    public boolean supports(Database database) {
        return KubernetesConnector.getInstance().isConnected();
    }

    public void waitForLock() throws LockException {
        try {
            String lockedBy = (String)ExecutorService.getInstance().getExecutor(this.database).queryForObject((SqlStatement)new SelectFromDatabaseChangeLogLockStatement(new String[]{"LOCKEDBY"}), String.class);
            if (StringUtils.isNotBlank((CharSequence)lockedBy)) {
                LOG.trace((Object)("Database locked by: " + lockedBy));
                StringTokenizer tok = new StringTokenizer(lockedBy, ":");
                if (tok.countTokens() == 2) {
                    Boolean lockHolderPodActive;
                    String podNamespace = tok.nextToken();
                    String podName = tok.nextToken();
                    if (KubernetesConnector.getInstance().isCurrentPod(podNamespace, podName)) {
                        LOG.debug((Object)"Lock created by the same pod, release lock");
                        this.releaseLock();
                    }
                    if ((lockHolderPodActive = KubernetesConnector.getInstance().isPodActive(podNamespace, podName)) != null && !lockHolderPodActive.booleanValue()) {
                        LOG.debug((Object)"Lock created by an inactive pod, release lock");
                        this.releaseLock();
                    }
                } else {
                    LOG.debug((Object)("Can't parse LOCKEDBY field: " + lockedBy));
                }
            } else {
                LOG.trace((Object)"Databased is not locked");
            }
        }
        catch (DatabaseException e) {
            LOG.error((Object)"Can't read the LOCKEDBY field from databasechangeloglock", (Throwable)e);
        }
        super.waitForLock();
    }
}

