/*
 * Decompiled with CFR 0.152.
 */
package com.github.patricio78.liquibase.kubernetes;

import com.github.patricio78.liquibase.kubernetes.KubernetesConnector;
import java.sql.Timestamp;
import java.util.Date;
import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.LockDatabaseChangeLogGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.LockDatabaseChangeLogStatement;
import liquibase.statement.core.UpdateStatement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LockDatabaseChangeLogGeneratorKubernetes
extends LockDatabaseChangeLogGenerator {
    private static final Log LOG = LogFactory.getLog(LockDatabaseChangeLogGeneratorKubernetes.class);

    public int getPriority() {
        return 1000;
    }

    public boolean supports(LockDatabaseChangeLogStatement statement, Database database) {
        return KubernetesConnector.getInstance().isConnected();
    }

    public Sql[] generateSql(LockDatabaseChangeLogStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String liquibaseSchema = database.getLiquibaseSchemaName();
        String liquibaseCatalog = database.getLiquibaseCatalogName();
        UpdateStatement updateStatement = new UpdateStatement(liquibaseCatalog, liquibaseSchema, database.getDatabaseChangeLogLockTableName());
        updateStatement.addNewColumnValue("LOCKED", (Object)true);
        updateStatement.addNewColumnValue("LOCKGRANTED", (Object)new Timestamp(new Date().getTime()));
        updateStatement.addNewColumnValue("LOCKEDBY", (Object)String.format("%s:%s", KubernetesConnector.getInstance().getPodNamespace(), KubernetesConnector.getInstance().getPodName()));
        updateStatement.setWhereClause(database.escapeColumnName(liquibaseCatalog, liquibaseSchema, database.getDatabaseChangeLogTableName(), "ID") + " = 1 AND " + database.escapeColumnName(liquibaseCatalog, liquibaseSchema, database.getDatabaseChangeLogTableName(), "LOCKED") + " = " + DataTypeFactory.getInstance().fromDescription("boolean", database).objectToSql((Object)false, database));
        return SqlGeneratorFactory.getInstance().generateSql((SqlStatement)updateStatement, database);
    }
}

