/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext;

import com.github.patricio78.liquibase.kubernetes.KubernetesConnector;
import java.util.StringTokenizer;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LockException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.lockservice.StandardLockService;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.SelectFromDatabaseChangeLogLockStatement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesLockService
extends StandardLockService {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesLockService.class);

    public int getPriority() {
        return 1000;
    }

    public boolean supports(Database database) {
        return KubernetesConnector.getInstance().isConnected();
    }

    public void waitForLock() throws LockException {
        try {
            Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
            String lockedBy = (String)executor.queryForObject((SqlStatement)new SelectFromDatabaseChangeLogLockStatement(new String[]{"LOCKEDBY"}), String.class);
            if (StringUtils.isNotBlank((CharSequence)lockedBy)) {
                LOG.trace("Database locked by: {}", (Object)lockedBy);
                StringTokenizer tok = new StringTokenizer(lockedBy, ":");
                if (tok.countTokens() == 2) {
                    boolean lockHolderPodActive;
                    String podNamespace = tok.nextToken();
                    String podName = tok.nextToken();
                    if (KubernetesConnector.getInstance().isCurrentPod(podNamespace, podName)) {
                        LOG.debug("Lock created by the same pod, release lock");
                        this.releaseLock();
                    }
                    if (!(lockHolderPodActive = KubernetesConnector.getInstance().isPodActive(podNamespace, podName))) {
                        LOG.debug("Lock created by an inactive pod, release lock");
                        this.releaseLock();
                    }
                } else {
                    LOG.debug("Can't parse LOCKEDBY field: {}", (Object)lockedBy);
                }
            } else {
                LOG.trace("Databased is not locked");
            }
        }
        catch (DatabaseException e) {
            LOG.error("Can't read the LOCKEDBY field from databasechangeloglock", (Throwable)e);
        }
        super.waitForLock();
    }
}

