/*
 * Decompiled with CFR 0.152.
 */
package com.github.patricio78.liquibase.kubernetes;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.util.Config;
import java.io.IOException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesConnector {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesConnector.class);
    public static final String POD_PHASE_PENDING = "Pending";
    public static final String POD_PHASE_RUNNING = "Running";
    public static final int HTTP_STATUS_NOT_FOUND = 404;
    private final boolean connected;
    private final String podName = System.getenv().get("POD_NAME");
    private final String podNamespace = System.getenv().get("POD_NAMESPACE");

    public static KubernetesConnector getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private KubernetesConnector() {
        if (StringUtils.isNotBlank((CharSequence)this.podName) && StringUtils.isNotBlank((CharSequence)this.podNamespace)) {
            this.connected = this.connect();
        } else {
            this.connected = false;
            LOG.warn("POD_NAME or POD_NAMESPACE is not configured, Liquibase - Kubernetes integration disabled");
        }
    }

    private boolean connect() {
        V1Pod pod;
        block4: {
            LOG.info("Create client with from cluster configuration");
            ApiClient client = Config.fromCluster();
            Configuration.setDefaultApiClient((ApiClient)client);
            LOG.info("BasePath: {}", (Object)client.getBasePath());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Authentication: {}", (Object)client.getAuthentications().entrySet().stream().map(entry -> String.valueOf((String)entry.getKey()) + ":" + entry.getValue()).collect(Collectors.joining(", ")));
            }
            CoreV1Api api = new CoreV1Api();
            LOG.info("Reading pod status, Pod name: {} Pod namespace: {}", (Object)this.podName, (Object)this.podNamespace);
            pod = api.readNamespacedPodStatus(this.podName, this.podNamespace, "true");
            if (pod != null && pod.getStatus() != null) break block4;
            return false;
        }
        try {
            String podPhase = pod.getStatus().getPhase();
            LOG.info("Pod phase: {}", (Object)podPhase);
            LOG.info("Connected to Kubernetes using fromCluster configuration");
            return true;
        }
        catch (ApiException | IOException e) {
            LOG.error("Connection fail to Kubernetes cluster using fromCluster configuration");
            LOG.error("Pod status read error", e);
            return false;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getPodName() {
        return this.podName;
    }

    public String getPodNamespace() {
        return this.podNamespace;
    }

    public boolean isCurrentPod(String podNamespace, String podName) {
        if (podNamespace == null || podName == null) {
            return false;
        }
        return podNamespace.equals(this.podNamespace) && podName.equals(this.podName);
    }

    public boolean isPodActive(String podNamespace, String podName) {
        String podPhase;
        block6: {
            V1Pod pod;
            block5: {
                try {
                    CoreV1Api api = new CoreV1Api();
                    LOG.info("Reading pod status, Pod name: {} Pod namespace: {}", (Object)podName, (Object)podNamespace);
                    pod = api.readNamespacedPodStatus(podName, podNamespace, "true");
                    if (pod != null && pod.getStatus() != null) break block5;
                    return false;
                }
                catch (ApiException e) {
                    if (e.getCode() == 404) {
                        LOG.error("Can't find pod");
                        return false;
                    }
                    LOG.error("Can't read Pod status: {}:{}", (Object)podNamespace, (Object)podName);
                    LOG.error("Pod status read error", (Throwable)e);
                    return false;
                }
            }
            podPhase = pod.getStatus().getPhase();
            if (!POD_PHASE_PENDING.equals(podPhase) && !POD_PHASE_RUNNING.equals(podPhase)) break block6;
            LOG.info("Pod is active, phase: {}", (Object)podPhase);
            return true;
        }
        LOG.info("Pod is inactive, phase: {}", (Object)podPhase);
        return false;
    }

    /* synthetic */ KubernetesConnector(KubernetesConnector kubernetesConnector) {
        this();
    }

    private static final class InstanceHolder {
        private static final KubernetesConnector INSTANCE = new KubernetesConnector(null);

        private InstanceHolder() {
        }
    }
}

