/*
 * Decompiled with CFR 0.152.
 */
package com.github.paulcwarren.ginkgo4j;

import com.github.paulcwarren.ginkgo4j.Ginkgo4jConfiguration;
import impl.com.github.paulcwarren.ginkgo4j.Spec;
import impl.com.github.paulcwarren.ginkgo4j.builder.TestWalker;
import impl.com.github.paulcwarren.ginkgo4j.chains.ExecutableChain;
import impl.com.github.paulcwarren.ginkgo4j.chains.ExecutableChainBuilder;
import impl.com.github.paulcwarren.ginkgo4j.chains.SpecsCollector;
import impl.com.github.paulcwarren.ginkgo4j.junit.JunitDescriptionsCollector;
import impl.com.github.paulcwarren.ginkgo4j.junit.JunitRunnerListener;
import impl.com.github.paulcwarren.ginkgo4j.runner.RunnerListener;
import impl.com.github.paulcwarren.ginkgo4j.runner.SpecRunner;
import impl.com.github.paulcwarren.ginkgo4j.runner.SpecSkipper;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

public class Ginkgo4jRunner
extends Runner {
    private Class<?> testClass;
    private Map<String, Description> descriptions = new HashMap<String, Description>();
    private Description description;

    public Ginkgo4jRunner(Class<?> testClass) throws InitializationError {
        this.testClass = testClass;
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = Description.createSuiteDescription((String)this.testClass.getName(), (Annotation[])new Annotation[0]);
            JunitDescriptionsCollector descCollector = new JunitDescriptionsCollector(this.description);
            try {
                new TestWalker(this.testClass).walk(descCollector);
            }
            finally {
                this.descriptions = descCollector.getDescriptions();
            }
        }
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        this.getDescription();
        try {
            notifier.fireTestStarted(this.description);
            List<ExecutableChain> chains = Ginkgo4jRunner.calculateExecutionChains(this.testClass);
            JunitRunnerListener listener = new JunitRunnerListener(notifier, this.descriptions);
            List<Runnable> runners = Ginkgo4jRunner.calculateWorkerThreads(chains, listener);
            Ginkgo4jRunner.threadExecute(runners, Ginkgo4jRunner.getThreads(this.testClass));
        }
        catch (Exception e) {
            notifier.fireTestFailure(new Failure(this.description, (Throwable)e));
        }
        finally {
            notifier.fireTestFinished(this.description);
        }
    }

    static List<ExecutableChain> calculateExecutionChains(Class<?> testClass) {
        SpecsCollector specCollector = new SpecsCollector();
        new TestWalker(testClass).walk(specCollector);
        ArrayList<ExecutableChain> chains = new ArrayList<ExecutableChain>();
        for (Spec spec : specCollector.getSpecs()) {
            ExecutableChainBuilder bldr = new ExecutableChainBuilder(spec.getId());
            new TestWalker(testClass).walk(bldr);
            chains.add(bldr.getExecutableChain());
        }
        return chains;
    }

    static List<impl.com.github.paulcwarren.ginkgo4j.runner.Runner> calculateWorkerThreads(List<ExecutableChain> chains) {
        ArrayList<SpecSkipper> skippedWorkers = new ArrayList<SpecSkipper>();
        ArrayList<SpecRunner> focusedWorkers = new ArrayList<SpecRunner>();
        ArrayList<impl.com.github.paulcwarren.ginkgo4j.runner.Runner> workers = new ArrayList<impl.com.github.paulcwarren.ginkgo4j.runner.Runner>();
        for (ExecutableChain chain : chains) {
            if (chain.isFocused()) {
                focusedWorkers.add(new SpecRunner(chain));
                continue;
            }
            workers.add(new SpecRunner(chain));
            skippedWorkers.add(new SpecSkipper(chain));
        }
        if (focusedWorkers.size() > 0) {
            workers = new ArrayList();
            workers.addAll(focusedWorkers);
            workers.addAll(skippedWorkers);
            return workers;
        }
        return workers;
    }

    static List<Runnable> calculateWorkerThreads(List<ExecutableChain> chains, RunnerListener listener) {
        ArrayList<SpecSkipper> skippedWorkers = new ArrayList<SpecSkipper>();
        ArrayList<SpecRunner> focusedWorkers = new ArrayList<SpecRunner>();
        ArrayList<Runnable> workers = new ArrayList<Runnable>();
        for (ExecutableChain chain : chains) {
            if (chain.isFocused()) {
                focusedWorkers.add(new SpecRunner(chain, listener));
                continue;
            }
            workers.add(new SpecRunner(chain, listener));
            skippedWorkers.add(new SpecSkipper(chain, listener));
        }
        if (focusedWorkers.size() > 0) {
            workers = new ArrayList();
            workers.addAll(focusedWorkers);
            workers.addAll(skippedWorkers);
            return workers;
        }
        return workers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void threadExecute(List<Runnable> workers, int threads) {
        try {
            ExecutorService executor = Executors.newFixedThreadPool(threads);
            for (Runnable runner : workers) {
                executor.execute(runner);
            }
            executor.shutdown();
            while (!executor.isTerminated()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static int getThreads(Class<?> testClass) {
        Ginkgo4jConfiguration config = testClass.getAnnotation(Ginkgo4jConfiguration.class);
        if (config != null) {
            return config.threads();
        }
        return 4;
    }
}

