/*
 * Decompiled with CFR 0.152.
 */
package impl.com.github.paulcwarren.ginkgo4j.chains;

import com.github.paulcwarren.ginkgo4j.ExecutableBlock;
import impl.com.github.paulcwarren.ginkgo4j.Context;
import impl.com.github.paulcwarren.ginkgo4j.Describe;
import impl.com.github.paulcwarren.ginkgo4j.IdBuilder;
import impl.com.github.paulcwarren.ginkgo4j.builder.TestVisitor;
import impl.com.github.paulcwarren.ginkgo4j.chains.ExecutableChain;
import java.util.regex.Pattern;

public class ExecutableChainBuilder
implements TestVisitor {
    private String filter;
    private ExecutableChain chain;

    public ExecutableChainBuilder(String specId) {
        this.filter = specId;
        this.chain = new ExecutableChain(specId);
    }

    public ExecutableChain getExecutableChain() {
        return this.chain;
    }

    @Override
    public void describe(String text, ExecutableBlock block, boolean isFocused) {
        if (this.filter.startsWith((text = IdBuilder.id(text)) + ".")) {
            this.filter = this.splitFilter(this.filter, text);
            this.chain.setIsFocused(isFocused);
            try {
                this.chain.getContext().add(new Describe(text));
                block.invoke();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void context(String text, ExecutableBlock block, boolean isFocused) {
        if (this.filter.startsWith((text = IdBuilder.id(text)) + ".")) {
            this.filter = this.splitFilter(this.filter, text);
            this.chain.setIsFocused(isFocused |= this.chain.isFocused());
            try {
                this.chain.getContext().add(new Context(text));
                block.invoke();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void beforeEach(ExecutableBlock block) {
        this.chain.getContext().get(this.chain.getContext().size() - 1).setBeforeEach(block);
    }

    @Override
    public void justBeforeEach(ExecutableBlock block) {
        this.chain.getContext().get(this.chain.getContext().size() - 1).setJustBeforeEach(block);
    }

    @Override
    public void it(String text, ExecutableBlock block, boolean isFocused) {
        if (this.filter.equals(text = IdBuilder.id(text))) {
            this.filter = this.splitFilter(this.filter, text);
            try {
                this.chain.setSpec(block);
                this.chain.setIsFocused(isFocused |= this.chain.isFocused());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void afterEach(ExecutableBlock block) {
        this.chain.getContext().get(this.chain.getContext().size() - 1).setAfterEach(block);
    }

    private String splitFilter(String filter, String text) {
        String newFilter = filter.replaceFirst(Pattern.quote(text), "");
        if (newFilter.startsWith(".")) {
            newFilter = newFilter.substring(1, newFilter.length());
        }
        return newFilter;
    }

    @Override
    public void test(Object test) {
        this.chain.setTestObject(test);
    }
}

