/*
 * Decompiled with CFR 0.152.
 */
package impl.com.github.paulcwarren.ginkgo4j.junit;

import impl.com.github.paulcwarren.ginkgo4j.runner.RunnerListener;
import java.util.Map;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class JunitRunnerListener
implements RunnerListener {
    private RunNotifier notifier;
    private Map<String, Description> descriptions;

    public JunitRunnerListener(RunNotifier notifier, Map<String, Description> descriptions) {
        this.notifier = notifier;
        this.descriptions = descriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testStarted(String specId) {
        RunNotifier runNotifier = this.notifier;
        synchronized (runNotifier) {
            this.notifier.fireTestStarted(this.descriptions.get(specId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testException(String specId, Throwable t) {
        if (t instanceof AssumptionViolatedException) {
            RunNotifier runNotifier = this.notifier;
            synchronized (runNotifier) {
                this.notifier.fireTestAssumptionFailed(new Failure(this.descriptions.get(specId), t));
            }
        }
        RunNotifier runNotifier = this.notifier;
        synchronized (runNotifier) {
            this.notifier.fireTestFailure(new Failure(this.descriptions.get(specId), t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testFinished(String specId) {
        RunNotifier runNotifier = this.notifier;
        synchronized (runNotifier) {
            this.notifier.fireTestFinished(this.descriptions.get(specId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testSkipped(String specId) {
        RunNotifier runNotifier = this.notifier;
        synchronized (runNotifier) {
            this.notifier.fireTestIgnored(this.descriptions.get(specId));
        }
    }
}

