/*
 * Decompiled with CFR 0.152.
 */
package com.github.paulcwarren.ginkgo4j.matchers;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class Ginkgo4jMatchers {
    private Ginkgo4jMatchers() {
    }

    public static <T> void eventually(Supplier<T> subjectSupplier, Consumer<T> expectations) throws InterruptedException {
        Ginkgo4jMatchers.eventually(subjectSupplier, expectations, Duration.ofMillis(1000L), Duration.ofSeconds(10L));
    }

    public static <T> void eventually(Supplier<T> subjectSupplier, Consumer<T> expectations, Duration interval, Duration timeout) throws InterruptedException {
        Instant start = Instant.now();
        Object result = null;
        do {
            result = subjectSupplier.get();
            Thread.sleep(interval.toMillis());
            if (result == null) continue;
            try {
                expectations.accept(result);
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        } while (Duration.between(start, Instant.now()).compareTo(timeout) < 0);
        throw new AssertionError();
    }
}

