/*
 * Decompiled with CFR 0.152.
 */
package impl.com.github.paulcwarren.ginkgo4j.junit;

import com.github.paulcwarren.ginkgo4j.ExecutableBlock;
import impl.com.github.paulcwarren.ginkgo4j.IdBuilder;
import impl.com.github.paulcwarren.ginkgo4j.TitleBuilder;
import impl.com.github.paulcwarren.ginkgo4j.builder.TestVisitor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.junit.runner.Description;

public class JunitDescriptionsCollector
implements TestVisitor {
    private Map<String, Description> descriptions = new HashMap<String, Description>();
    private Stack<Description> descContext = new Stack();
    private Stack<String> idContext = new Stack();
    private Description description;

    public JunitDescriptionsCollector(Description description) {
        this.description = description;
    }

    public Map<String, Description> getDescriptions() {
        return this.descriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void describe(String text, ExecutableBlock block, boolean isFocused) {
        text = TitleBuilder.title(text);
        String id = IdBuilder.id(text);
        String fqid = IdBuilder.fqid(text, this.idContext);
        Description desc = Description.createSuiteDescription((String)text, (Serializable)((Object)fqid), (Annotation[])new Annotation[0]);
        this.descriptions.put(fqid, desc);
        if (this.descContext.isEmpty()) {
            this.description.addChild(desc);
        } else {
            this.safePeek(desc);
        }
        this.descContext.push(desc);
        this.idContext.push(id);
        try {
            block.invoke();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.descContext.pop();
            this.idContext.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void context(String text, ExecutableBlock block, boolean isFocused) {
        text = TitleBuilder.title(text);
        String id = IdBuilder.id(text);
        String fqid = IdBuilder.fqid(text, this.idContext);
        Description childDesc = Description.createSuiteDescription((String)text, (Serializable)((Object)fqid), (Annotation[])new Annotation[0]);
        this.descriptions.put(fqid, childDesc);
        if (this.descContext.isEmpty()) {
            this.description.addChild(childDesc);
        } else {
            this.safePeek(childDesc);
        }
        this.descContext.push(childDesc);
        this.idContext.push(id);
        try {
            block.invoke();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.descContext.pop();
            this.idContext.pop();
        }
    }

    @Override
    public void beforeEach(ExecutableBlock block) {
    }

    @Override
    public void justBeforeEach(ExecutableBlock block) {
    }

    @Override
    public void it(String text, ExecutableBlock block, boolean isFocused) {
        text = TitleBuilder.title(text);
        String id = IdBuilder.fqid(text, this.idContext);
        Description itDesc = Description.createTestDescription((String)"It", (String)text, (Serializable)((Object)id));
        this.descriptions.put(id, itDesc);
        try {
            this.safePeek(itDesc);
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    @Override
    public void afterEach(ExecutableBlock block) {
    }

    private void safePeek(Description childDesc) {
        try {
            this.descContext.peek().addChild(childDesc);
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    @Override
    public void test(Object test) {
    }
}

