/*
 * Decompiled with CFR 0.152.
 */
package com.github.paulcwarren.ginkgo4j.maven;

import com.github.paulcwarren.ginkgo4j.maven.ByteArrayPrintStream;
import com.github.paulcwarren.ginkgo4j.maven.ThreadPrintStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnitRunListener
extends RunListener {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";
    private PrintStream console;
    private ThreadLocal<Boolean> testErrored = new ThreadLocal();

    public void testRunStarted(Description description) {
        this.console = System.out;
        ThreadPrintStream.replaceSystemOut();
    }

    public void testRunFinished(Result result) {
    }

    public void testStarted(Description description) {
        this.testErrored.set(false);
        ByteArrayPrintStream stream = new ByteArrayPrintStream(new ByteArrayOutputStream());
        ((ThreadPrintStream)System.out).setThreadOut(stream);
    }

    public void testFinished(Description description) {
        if (this.isTest(description) && !this.testErrored.get().booleanValue()) {
            PrintStream printWriter = null;
            try {
                printWriter = new PrintStream((OutputStream)this.console, true, Charset.forName("UTF-8").name());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            char bullet = '\u2022';
            printWriter.print(ANSI_GREEN);
            printWriter.print(bullet);
            printWriter.print(ANSI_RESET);
            printWriter.flush();
        }
    }

    public void testFailure(Failure failure) {
        this.testErrored.set(true);
        this.console.println();
        this.console.print(ANSI_RED);
        this.console.println(this.getTestName(failure.getDescription()));
        failure.getException().printStackTrace(this.console);
        ByteArrayPrintStream outputStream = (ByteArrayPrintStream)((ThreadPrintStream)System.out).getThreadOut();
        this.console.println(new String(outputStream.getByteArrayOutputStream().toByteArray()));
        this.console.print(ANSI_RESET);
        this.console.flush();
    }

    public void testAssumptionFailure(Failure failure) {
        this.testErrored.set(true);
        this.console.println();
        this.console.print(ANSI_RED);
        this.console.println(this.getTestName(failure.getDescription()));
        failure.getException().printStackTrace(this.console);
        ByteArrayPrintStream outputStream = (ByteArrayPrintStream)((ThreadPrintStream)System.out).getThreadOut();
        this.console.println(new String(outputStream.getByteArrayOutputStream().toByteArray()));
        this.console.print(ANSI_RESET);
        this.console.flush();
    }

    public void testIgnored(Description description) {
        this.console.print(ANSI_BLUE);
        this.console.print("S");
        this.console.print(ANSI_RESET);
        this.console.flush();
    }

    private boolean isTest(Description description) {
        return description.getMethodName() != null;
    }

    private String getTestName(Description description) {
        Field privateStringField = null;
        try {
            privateStringField = Description.class.getDeclaredField("fUniqueId");
            privateStringField.setAccessible(true);
            String fieldValue = (String)privateStringField.get(description);
            fieldValue = fieldValue.replaceAll("\\.", " ");
            return fieldValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Unknown test";
        }
    }
}

