/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.fs.boot.autoconfigure;

import internal.org.springframework.content.fs.boot.autoconfigure.FilesystemContentAutoConfigureRegistrar;
import internal.org.springframework.content.fs.config.FilesystemStoreConfiguration;
import internal.org.springframework.content.fs.config.FilesystemStoreFactoryBean;
import internal.org.springframework.content.fs.config.FilesystemStoreRegistrar;
import internal.org.springframework.versions.jpa.boot.autoconfigure.JpaVersionsAutoConfiguration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.content.fs.io.FileSystemResourceLoader;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Component;

@Configuration
@AutoConfigureAfter(value={JpaVersionsAutoConfiguration.class})
@ConditionalOnClass(value={FilesystemStoreRegistrar.class})
public class FilesystemContentAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={FileSystemResourceLoader.class})
    FileSystemResourceLoader fileSystemResourceLoader(FilesystemProperties props) {
        return new FileSystemResourceLoader(props.getFilesystemRoot());
    }

    @Component
    @ConfigurationProperties(prefix="spring.content.fs")
    public static class FilesystemProperties {
        private static final Logger logger = LoggerFactory.getLogger(FilesystemProperties.class);
        String filesystemRoot;

        public String getFilesystemRoot() {
            if (this.filesystemRoot == null) {
                try {
                    this.filesystemRoot = Files.createTempDirectory("", new FileAttribute[0]).toString();
                }
                catch (IOException ioe) {
                    logger.error(String.format("Unexpected error defaulting filesystem root to %s", this.filesystemRoot), (Throwable)ioe);
                }
            }
            return this.filesystemRoot;
        }

        public void setFilesystemRoot(String filesystemRoot) {
            this.filesystemRoot = filesystemRoot;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={FilesystemStoreFactoryBean.class})
    @Import(value={FilesystemContentAutoConfigureRegistrar.class, FilesystemStoreConfiguration.class})
    public static class EnableFilesystemStoresConfig {
    }
}

