/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.versions.jpa.boot.autoconfigure;

import internal.org.springframework.versions.jpa.boot.autoconfigure.JpaVersionsAutoConfigureRegistrar;
import internal.org.springframework.versions.jpa.boot.autoconfigure.JpaVersionsDatabaseInitializer;
import internal.org.springframework.versions.jpa.boot.autoconfigure.JpaVersionsProperties;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.ResourceLoader;
import org.springframework.versions.jpa.config.JpaLockingAndVersioningConfig;

@Configuration
@ConditionalOnClass(value={DataSource.class, JpaLockingAndVersioningConfig.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@Import(value={JpaLockingAndVersioningConfig.class})
@EnableConfigurationProperties(value={JpaVersionsProperties.class})
public class JpaVersionsAutoConfiguration {
    private final JpaVersionsProperties properties;

    public JpaVersionsAutoConfiguration(JpaVersionsProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={DataSource.class})
    public JpaVersionsDatabaseInitializer jpaVersionsDatabaseInitializer(DataSource dataSource, ResourceLoader resourceLoader) {
        return new JpaVersionsDatabaseInitializer(dataSource, resourceLoader, this.properties);
    }

    @Configuration
    @Import(value={JpaVersionsAutoConfigureRegistrar.class})
    public static class JpaVersionAutoConfig {
    }
}

