/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.boot.autoconfigure;

import internal.org.springframework.content.rest.boot.autoconfigure.SpringBootContentRestConfigurer;
import java.net.URI;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.content.rest.config.RestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Component;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={RestConfiguration.class})
@Import(value={RestConfiguration.class})
public class ContentRestAutoConfiguration {
    @Bean
    public SpringBootContentRestConfigurer springBootContentRestConfigurer() {
        return new SpringBootContentRestConfigurer();
    }

    @Component
    @ConfigurationProperties(prefix="spring.content.rest")
    public static class ContentRestProperties {
        private URI baseUri;
        private boolean fullyQualifiedLinks = RestConfiguration.FULLY_QUALIFIED_DEFAULTS_DEFAULT;

        public URI getBaseUri() {
            return this.baseUri;
        }

        public void setBaseUri(URI baseUri) {
            this.baseUri = baseUri;
        }

        public boolean fullyQualifiedLinks() {
            return this.fullyQualifiedLinks;
        }

        public void setFullyQualifiedLinks(boolean fullyQualifiedLinks) {
            this.fullyQualifiedLinks = fullyQualifiedLinks;
        }
    }
}

