/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.commons.renditions;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.annotations.MimeType;
import org.springframework.content.commons.renditions.Renderable;
import org.springframework.content.commons.renditions.RenditionProvider;
import org.springframework.content.commons.renditions.RenditionService;
import org.springframework.content.commons.repository.StoreExtension;
import org.springframework.content.commons.repository.StoreInvoker;
import org.springframework.content.commons.utils.BeanUtils;

public class RenditionServiceImpl
implements RenditionService,
StoreExtension {
    private static final Log LOGGER = LogFactory.getLog(RenditionServiceImpl.class);
    private List<RenditionProvider> providers = new ArrayList<RenditionProvider>();

    @Autowired(required=false)
    public void setProviders(RenditionProvider ... providers) {
        for (RenditionProvider provider : providers) {
            this.providers.add(provider);
        }
    }

    @Override
    public boolean canConvert(String fromMimeType, String toMimeType) {
        for (RenditionProvider provider : this.providers) {
            if (!org.springframework.util.MimeType.valueOf((String)fromMimeType).includes(org.springframework.util.MimeType.valueOf((String)provider.consumes()))) continue;
            for (String produce : provider.produces()) {
                if (!org.springframework.util.MimeType.valueOf((String)toMimeType).includes(org.springframework.util.MimeType.valueOf((String)produce))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] conversions(String fromMimeType) {
        HashSet<String> conversions = new HashSet<String>();
        for (RenditionProvider provider : this.providers) {
            if (!provider.consumes().equals(fromMimeType)) continue;
            conversions.addAll(Arrays.asList(provider.produces()));
        }
        return conversions.toArray(new String[0]);
    }

    @Override
    public InputStream convert(String fromMimeType, InputStream fromInputSource, String toMimeType) {
        for (RenditionProvider provider : this.providers) {
            if (!org.springframework.util.MimeType.valueOf((String)fromMimeType).includes(org.springframework.util.MimeType.valueOf((String)provider.consumes()))) continue;
            for (String produce : provider.produces()) {
                if (!org.springframework.util.MimeType.valueOf((String)toMimeType).includes(org.springframework.util.MimeType.valueOf((String)produce))) continue;
                return provider.convert(fromInputSource, toMimeType);
            }
        }
        return null;
    }

    @Override
    public Set<Method> getMethods() {
        Class<Renderable> clazz = Renderable.class;
        try {
            Method getRenditionMethod = clazz.getMethod("getRendition", Object.class, String.class);
            Set<Method> methods = Collections.singleton(getRenditionMethod);
            return methods;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to get Renderable.getRendtion method", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @Override
    public Object invoke(MethodInvocation invocation, StoreInvoker invoker) {
        String fromMimeType = null;
        fromMimeType = (String)BeanUtils.getFieldWithAnnotation(invocation.getArguments()[0], MimeType.class);
        if (fromMimeType == null) {
            return null;
        }
        String toMimeType = (String)invocation.getArguments()[1];
        if (this.canConvert(fromMimeType, toMimeType)) {
            InputStream content = null;
            try {
                content = invoker.invokeGetContent();
                return this.convert(fromMimeType, content, toMimeType);
            }
            catch (Exception e) {
                LOGGER.error((Object)String.format("Failed to get rendition from %s to %s", fromMimeType, toMimeType), (Throwable)e);
            }
        }
        return null;
    }
}

