/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.commons.storeservice;

import internal.org.springframework.content.commons.storeservice.ContentStoreInfoImpl;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.repository.factory.StoreFactory;
import org.springframework.content.commons.storeservice.ContentStoreInfo;
import org.springframework.content.commons.storeservice.ContentStoreService;
import org.springframework.content.commons.storeservice.StoreFilter;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;

public class ContentStoreServiceImpl
implements ContentStoreService {
    private Set<ContentStoreInfo> contentStoreInfos = new HashSet<ContentStoreInfo>();

    @Autowired(required=false)
    public void setFactories(List<StoreFactory> factories) {
        for (StoreFactory factory : factories) {
            ContentStoreInfoImpl info;
            if (ContentStore.class.isAssignableFrom(factory.getStoreInterface())) {
                info = new ContentStoreInfoImpl(factory.getStoreInterface(), ((TypeInformation)ClassTypeInformation.from(factory.getStoreInterface()).getRequiredSuperTypeInformation(ContentStore.class).getTypeArguments().get(0)).getType(), (ContentStore)factory.getStore());
                this.contentStoreInfos.add(info);
                continue;
            }
            info = new ContentStoreInfoImpl(factory.getStoreInterface(), this.getDomainObjectClass(factory.getStoreInterface()), (Store)factory.getStore());
            this.contentStoreInfos.add(info);
        }
    }

    private Class<?> getDomainObjectClass(Class<?> contentStoreInterface) {
        Type[] genericInterfaces;
        for (Type genericInterface : genericInterfaces = contentStoreInterface.getGenericInterfaces()) {
            if (!(genericInterface instanceof ParameterizedType) || !((ParameterizedType)genericInterface).getRawType().equals(ContentStore.class)) continue;
            Type t = ((ParameterizedType)genericInterface).getActualTypeArguments()[0];
            return (Class)t;
        }
        return null;
    }

    public Set<ContentStoreInfo> getContentStoreInfos() {
        return this.contentStoreInfos;
    }

    public void setContentStoreInfos(Set<ContentStoreInfo> contentStoreInfos) {
        this.contentStoreInfos = contentStoreInfos;
    }

    @Override
    public ContentStoreInfo[] getContentStores() {
        return this.getStores(ContentStore.class);
    }

    @Override
    public ContentStoreInfo[] getStores(Class<?> storeType) {
        return this.getStores(storeType, MATCH_ALL);
    }

    @Override
    public ContentStoreInfo[] getStores(Class<?> storeType, StoreFilter filter) {
        HashSet<ContentStoreInfo> storeInfos = new HashSet<ContentStoreInfo>();
        for (ContentStoreInfo info : this.contentStoreInfos) {
            if (info.getImplementation(storeType) == null || !filter.matches(info)) continue;
            storeInfos.add(info);
        }
        return storeInfos.toArray(new ContentStoreInfo[0]);
    }
}

