/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.commons.repository.factory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.springframework.content.commons.io.FileRemover;
import org.springframework.content.commons.io.ObservableInputStream;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.events.AfterAssociateEvent;
import org.springframework.content.commons.repository.events.AfterGetContentEvent;
import org.springframework.content.commons.repository.events.AfterGetResourceEvent;
import org.springframework.content.commons.repository.events.AfterSetContentEvent;
import org.springframework.content.commons.repository.events.AfterUnassociateEvent;
import org.springframework.content.commons.repository.events.AfterUnsetContentEvent;
import org.springframework.content.commons.repository.events.BeforeAssociateEvent;
import org.springframework.content.commons.repository.events.BeforeGetContentEvent;
import org.springframework.content.commons.repository.events.BeforeGetResourceEvent;
import org.springframework.content.commons.repository.events.BeforeSetContentEvent;
import org.springframework.content.commons.repository.events.BeforeUnassociateEvent;
import org.springframework.content.commons.repository.events.BeforeUnsetContentEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.io.Resource;

public class StoreImpl
implements ContentStore<Object, Serializable> {
    private final ContentStore<Object, Serializable> delegate;
    private final ApplicationEventPublisher publisher;

    public StoreImpl(ContentStore<Object, Serializable> delegate, ApplicationEventPublisher publisher) {
        this.delegate = delegate;
        this.publisher = publisher;
    }

    @Override
    public Object setContent(Object property, InputStream content) {
        Object result = null;
        try {
            File tmpStreamFile = Files.createTempFile("sc", "bsce", new FileAttribute[0]).toFile();
            TeeInputStream eventStream = new TeeInputStream(content, new FileOutputStream(tmpStreamFile), true);
            BeforeSetContentEvent before = new BeforeSetContentEvent(property, this.delegate, (InputStream)((Object)eventStream));
            AfterSetContentEvent after = new AfterSetContentEvent(property, this.delegate);
            this.publisher.publishEvent((ApplicationEvent)before);
            if (eventStream != null && eventStream.isDirty()) {
                while (eventStream.read(new byte[4096]) != -1) {
                }
                eventStream.close();
                content = new ObservableInputStream(new FileInputStream(tmpStreamFile), new FileRemover(tmpStreamFile));
            }
            result = this.delegate.setContent(property, content);
            if (after != null) {
                after.setResult(result);
                this.publisher.publishEvent((ApplicationEvent)after);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
        return result;
    }

    @Override
    public Object setContent(Object property, Resource resourceContent) {
        BeforeSetContentEvent before = new BeforeSetContentEvent(property, this.delegate, resourceContent);
        AfterSetContentEvent after = new AfterSetContentEvent(property, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)before);
        Object result = this.delegate.setContent(property, resourceContent);
        if (after != null) {
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
        return result;
    }

    @Override
    public Object unsetContent(Object property) {
        BeforeUnsetContentEvent before = new BeforeUnsetContentEvent(property, this.delegate);
        AfterUnsetContentEvent after = new AfterUnsetContentEvent(property, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)before);
        Object result = this.delegate.unsetContent(property);
        if (after != null) {
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
        return result;
    }

    @Override
    public InputStream getContent(Object property) {
        BeforeGetContentEvent before = new BeforeGetContentEvent(property, this.delegate);
        AfterGetContentEvent after = new AfterGetContentEvent(property, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)before);
        InputStream result = this.delegate.getContent(property);
        if (after != null) {
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
        return result;
    }

    @Override
    public Resource getResource(Object entity) {
        BeforeGetResourceEvent before = new BeforeGetResourceEvent(entity, this.delegate);
        AfterGetResourceEvent after = new AfterGetResourceEvent(entity, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)before);
        Resource result = this.delegate.getResource(entity);
        if (after != null) {
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
        return result;
    }

    @Override
    public Resource getResource(Serializable id) {
        BeforeGetResourceEvent before = new BeforeGetResourceEvent(id, this.delegate);
        AfterGetResourceEvent after = new AfterGetResourceEvent(id, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)before);
        Resource result = this.delegate.getResource((Object)id);
        if (after != null) {
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
        return result;
    }

    @Override
    public void associate(Object entity, Serializable id) {
        BeforeAssociateEvent before = new BeforeAssociateEvent(entity, this.delegate);
        AfterAssociateEvent after = new AfterAssociateEvent(entity, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)before);
        this.delegate.associate(entity, id);
        if (after != null) {
            this.publisher.publishEvent((ApplicationEvent)after);
        }
    }

    @Override
    public void unassociate(Object entity) {
        BeforeUnassociateEvent before = new BeforeUnassociateEvent(entity, this.delegate);
        AfterUnassociateEvent after = new AfterUnassociateEvent(entity, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)before);
        this.delegate.unassociate(entity);
        if (after != null) {
            this.publisher.publishEvent((ApplicationEvent)after);
        }
    }

    static class TeeInputStream
    extends org.apache.commons.io.input.TeeInputStream {
        private boolean isDirty = false;

        public TeeInputStream(InputStream input, OutputStream branch, boolean closeBranch) {
            super(input, branch, closeBranch);
        }

        public int read() throws IOException {
            this.isDirty = true;
            return super.read();
        }

        public int read(byte[] bts, int st, int end) throws IOException {
            this.isDirty = true;
            return super.read(bts, st, end);
        }

        public int read(byte[] bts) throws IOException {
            this.isDirty = true;
            return super.read(bts);
        }

        public boolean isDirty() {
            return this.isDirty;
        }
    }
}

