/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.commons.storeservice;

import internal.org.springframework.content.commons.storeservice.StoreInfoImpl;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.repository.factory.StoreFactory;
import org.springframework.content.commons.storeservice.StoreFilter;
import org.springframework.content.commons.storeservice.StoreInfo;
import org.springframework.content.commons.storeservice.StoreResolver;
import org.springframework.content.commons.storeservice.Stores;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class StoresImpl
implements Stores {
    private Set<StoreInfo> storeInfos = new HashSet<StoreInfo>();
    private Map<String, StoreResolver> resolvers = new HashMap<String, StoreResolver>();

    @Autowired(required=false)
    public void setFactories(List<StoreFactory> factories) {
        for (StoreFactory factory : factories) {
            StoreInfoImpl info;
            if (ContentStore.class.isAssignableFrom(factory.getStoreInterface())) {
                info = new StoreInfoImpl(factory.getStoreInterface(), ((TypeInformation)ClassTypeInformation.from(factory.getStoreInterface()).getRequiredSuperTypeInformation(ContentStore.class).getTypeArguments().get(0)).getType(), (ContentStore)factory.getStore());
                this.storeInfos.add(info);
                continue;
            }
            info = new StoreInfoImpl(factory.getStoreInterface(), this.getDomainObjectClass(factory.getStoreInterface()), (Store)factory.getStore());
            this.storeInfos.add(info);
        }
    }

    private Class<?> getDomainObjectClass(Class<?> contentStoreInterface) {
        Type[] genericInterfaces;
        for (Type genericInterface : genericInterfaces = contentStoreInterface.getGenericInterfaces()) {
            if (!(genericInterface instanceof ParameterizedType) || !((ParameterizedType)genericInterface).getRawType().equals(ContentStore.class)) continue;
            Type t = ((ParameterizedType)genericInterface).getActualTypeArguments()[0];
            return (Class)t;
        }
        return null;
    }

    @Override
    public void addStoreResolver(String name, StoreResolver resolver) {
        this.resolvers.put(name, resolver);
    }

    @Override
    public StoreInfo getStore(Class<?> storeType, StoreFilter filter) {
        Assert.notNull(storeType);
        Assert.notNull((Object)filter);
        ArrayList<StoreInfo> candidates = new ArrayList<StoreInfo>();
        for (StoreInfo info : this.storeInfos) {
            if (info.getImplementation(storeType) == null || !filter.matches(info)) continue;
            candidates.add(info);
        }
        if (candidates.size() == 1) {
            return (StoreInfo)candidates.get(0);
        }
        if (candidates.size() > 1) {
            StoreResolver resolver = this.resolvers.get(filter.name());
            if (resolver == null) {
                throw new IllegalStateException("unable to resolve store.  Consider adding a StoreResolver");
            }
            return resolver.resolve(candidates.toArray(new StoreInfo[0]));
        }
        return null;
    }

    @Override
    public StoreInfo[] getStores(Class<?> storeType) {
        return this.getStores(storeType, MATCH_ALL);
    }

    @Override
    public StoreInfo[] getStores(Class<?> storeType, StoreFilter filter) {
        HashSet<StoreInfo> storeInfos = new HashSet<StoreInfo>();
        for (StoreInfo info : this.storeInfos) {
            if (info.getImplementation(storeType) == null || !filter.matches(info)) continue;
            storeInfos.add(info);
        }
        return storeInfos.toArray(new StoreInfo[0]);
    }
}

