/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.commons.utils;

import java.io.IOException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.content.commons.repository.ContentRepository;
import org.springframework.content.commons.repository.Store;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class StoreCandidateComponentProvider
extends ClassPathScanningCandidateComponentProvider {
    public StoreCandidateComponentProvider(boolean useDefaultFilters, Environment env) {
        super(useDefaultFilters, env);
        this.addIncludeFilter((TypeFilter)new InterfaceTypeFilter(ContentRepository.class));
        this.addIncludeFilter((TypeFilter)new InterfaceTypeFilter(Store.class));
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return true;
    }

    private static class InterfaceTypeFilter
    extends AssignableTypeFilter {
        public InterfaceTypeFilter(Class<?> targetType) {
            super(targetType);
        }

        public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
            return metadataReader.getClassMetadata().isInterface() && super.match(metadataReader, metadataReaderFactory);
        }
    }
}

