/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.commons.utils;

import java.lang.reflect.Field;
import javax.persistence.Id;
import org.springframework.content.commons.utils.BeanUtils;

public final class DomainObjectUtils {
    private static boolean JAVAX_PERSISTENCE_ID_CLASS_PRESENT = false;

    private DomainObjectUtils() {
    }

    public static final Object getId(Object entity) {
        if (JAVAX_PERSISTENCE_ID_CLASS_PRESENT && BeanUtils.hasFieldWithAnnotation(entity, Id.class)) {
            return BeanUtils.getFieldWithAnnotation(entity, Id.class);
        }
        if (BeanUtils.hasFieldWithAnnotation(entity, org.springframework.data.annotation.Id.class)) {
            return BeanUtils.getFieldWithAnnotation(entity, org.springframework.data.annotation.Id.class);
        }
        return null;
    }

    public static final Field getIdField(Class<?> domainClass) {
        if (JAVAX_PERSISTENCE_ID_CLASS_PRESENT && BeanUtils.findFieldWithAnnotation(domainClass, Id.class) != null) {
            return BeanUtils.findFieldWithAnnotation(domainClass, Id.class);
        }
        if (BeanUtils.findFieldWithAnnotation(domainClass, org.springframework.data.annotation.Id.class) != null) {
            return BeanUtils.findFieldWithAnnotation(domainClass, org.springframework.data.annotation.Id.class);
        }
        return null;
    }

    static {
        try {
            JAVAX_PERSISTENCE_ID_CLASS_PRESENT = DomainObjectUtils.class.getClassLoader().loadClass("javax.persistence.Id") != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

