/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.commons.config;

import internal.org.springframework.content.commons.config.StoreFragment;
import internal.org.springframework.content.commons.config.StoreFragmentDefinition;
import internal.org.springframework.content.commons.config.StoreFragmentDetector;
import internal.org.springframework.content.commons.config.StoreFragmentsFactoryBean;
import internal.org.springframework.content.commons.repository.AnnotatedStoreEventInvoker;
import internal.org.springframework.content.commons.utils.StoreCandidateComponentProvider;
import internal.org.springframework.content.commons.utils.StoreUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.repository.factory.AbstractStoreFactoryBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractStoreBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware,
ResourceLoaderAware,
BeanFactoryAware {
    private static final Log LOGGER = LogFactory.getLog(AbstractStoreBeanDefinitionRegistrar.class);
    public static final String STORE_INTERFACE_PROPERTY = "storeInterface";
    public static final String DOMAIN_CLASS_PROPERTY = "domainClass";
    public static final String ID_CLASS_PROPERTY = "idClass";
    private static String REPOSITORY_INTERFACE_POST_PROCESSOR = "internal.org.springframework.content.commons.utils.StoreInterfaceAwareBeanPostProcessor";
    private Environment environment;
    private ResourceLoader resourceLoader;
    private BeanFactory beanFactory;
    private boolean multiStoreMode;

    public void setEnvironment(Environment env) {
        this.environment = env;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Assert.notNull((Object)importingClassMetadata, (String)"AnnotationMetadata must not be null!");
        Assert.notNull((Object)registry, (String)"BeanDefinitionRegistry must not be null!");
        Assert.isTrue((boolean)(registry instanceof ConfigurableListableBeanFactory), (String)"BeanDefinitionRegistry must be instance of ConfigurableListableBeanFactory");
        RootBeanDefinition repositoryInterfacePostProcessor = new RootBeanDefinition(REPOSITORY_INTERFACE_POST_PROCESSOR);
        repositoryInterfacePostProcessor.setSource((Object)importingClassMetadata);
        if (!registry.containsBeanDefinition(REPOSITORY_INTERFACE_POST_PROCESSOR)) {
            registry.registerBeanDefinition(REPOSITORY_INTERFACE_POST_PROCESSOR, (BeanDefinition)repositoryInterfacePostProcessor);
        }
        BeanDefinition annotatedStoreEventHandlerDef = this.createBeanDefinition(AnnotatedStoreEventInvoker.class);
        if (!registry.containsBeanDefinition("annotatedStoreEventHandler")) {
            registry.registerBeanDefinition("annotatedStoreEventHandler", annotatedStoreEventHandlerDef);
        }
        this.createOperationsBean(registry);
        this.registerContentStoreBeanDefinitions(importingClassMetadata, registry);
    }

    protected void registerContentStoreBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes attributes = new AnnotationAttributes(importingClassMetadata.getAnnotationAttributes(this.getAnnotation().getName()));
        String[] basePackages = this.getBasePackages(attributes, importingClassMetadata);
        StoreCandidateComponentProvider scanner = new StoreCandidateComponentProvider(false, this.environment);
        scanner.setResourceLoader(this.resourceLoader);
        Set<GenericBeanDefinition> definitions = StoreUtils.getStoreCandidates(scanner, this.environment, this.resourceLoader, basePackages, this.multipleStoreImplementationsDetected(), this.getSignatureTypes(), this.getOverridePropertyValue());
        this.buildAndRegisterDefinitions(importingClassMetadata, registry, attributes, basePackages, definitions);
    }

    protected void buildAndRegisterDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry, AnnotationAttributes attributes, String[] basePackages, Set<GenericBeanDefinition> definitions) {
        for (BeanDefinition beanDefinition : definitions) {
            String factoryBeanName = StoreUtils.getStoreFactoryBeanName(attributes);
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)factoryBeanName);
            builder.getRawBeanDefinition().setSource((Object)importingClassMetadata);
            builder.addPropertyValue(STORE_INTERFACE_PROPERTY, (Object)beanDefinition.getBeanClassName());
            CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory(this.resourceLoader);
            String storeInterface = beanDefinition.getBeanClassName();
            String[] interfaces = new String[]{};
            try {
                interfaces = metadataReaderFactory.getMetadataReader(storeInterface).getClassMetadata().getInterfaceNames();
            }
            catch (IOException e) {
                LOGGER.error((Object)String.format("Reading store interface %s", storeInterface), (Throwable)e);
            }
            StoreFragmentDetector detector = new StoreFragmentDetector(this.environment, this.resourceLoader, "Impl", basePackages, (MetadataReaderFactory)metadataReaderFactory);
            try {
                Class<?> storeClass = this.loadStoreClass((ConfigurableListableBeanFactory)registry, beanDefinition);
                List types = null;
                try {
                    types = ClassTypeInformation.from(storeClass).getRequiredSuperTypeInformation(ContentStore.class).getTypeArguments();
                }
                catch (IllegalArgumentException iae) {
                    try {
                        types = ClassTypeInformation.from(storeClass).getRequiredSuperTypeInformation(AssociativeStore.class).getTypeArguments();
                    }
                    catch (IllegalArgumentException iae2) {
                        try {
                            types = ClassTypeInformation.from(storeClass).getRequiredSuperTypeInformation(Store.class).getTypeArguments();
                        }
                        catch (IllegalArgumentException iae3) {
                            return;
                        }
                    }
                }
                Class domainClass = types.size() == 2 ? ((TypeInformation)types.get(0)).getType() : null;
                Class idClass = types.size() == 2 ? ((TypeInformation)types.get(1)).getType() : ((TypeInformation)types.get(0)).getType();
                IsCandidatePredicate isCandidate = new IsCandidatePredicate(this.getSignatureTypes());
                List fragmentBeanNames = Arrays.stream(interfaces).filter(isCandidate::test).map(iface -> detector.detectCustomImplementation((String)iface, storeInterface)).peek(it -> this.registerStoreFragmentImplementation(registry, importingClassMetadata, (StoreFragmentDefinition)it, domainClass, idClass)).peek(it -> this.registerStoreFragment(registry, importingClassMetadata, (StoreFragmentDefinition)it)).map(it -> it.getFragmentBeanName()).collect(Collectors.toList());
                BeanDefinitionBuilder fragmentsBuilder = BeanDefinitionBuilder.rootBeanDefinition(StoreFragmentsFactoryBean.class);
                fragmentsBuilder.addConstructorArgValue(fragmentBeanNames);
                registry.registerBeanDefinition(StoreUtils.getStoreBeanName(beanDefinition) + "#StoreFragments", (BeanDefinition)fragmentsBuilder.getBeanDefinition());
                builder.addPropertyValue("storeFragments", (Object)ParsingUtils.getSourceBeanDefinition((BeanDefinitionBuilder)fragmentsBuilder, (Object)importingClassMetadata));
            }
            catch (ClassNotFoundException e) {
                LOGGER.error((Object)String.format("Instantiating store class %s", storeInterface), (Throwable)e);
            }
            registry.registerBeanDefinition(StoreUtils.getStoreBeanName(beanDefinition), (BeanDefinition)builder.getBeanDefinition());
        }
    }

    protected String[] getBasePackages(AnnotationAttributes attributes, AnnotationMetadata importingClassMetadata) {
        return StoreUtils.getBasePackages(attributes, new String[]{ClassUtils.getPackageName((String)importingClassMetadata.getClassName())});
    }

    protected BeanDefinition createBeanDefinition(Class<?> beanType) {
        GenericBeanDefinition beanDef = new GenericBeanDefinition();
        beanDef.setBeanClass(beanType);
        MutablePropertyValues values = new MutablePropertyValues();
        beanDef.setPropertyValues(values);
        return beanDef;
    }

    protected Class<?> loadStoreClass(ConfigurableListableBeanFactory registry, BeanDefinition definition) throws ClassNotFoundException {
        return ClassUtils.forName((String)definition.getBeanClassName(), (ClassLoader)registry.getBeanClassLoader());
    }

    protected void createOperationsBean(BeanDefinitionRegistry registry) {
    }

    private void registerStoreFragmentImplementation(BeanDefinitionRegistry registry, AnnotationMetadata source, StoreFragmentDefinition fragmentDefinition, Class<?> domainClass, Class<?> idClass) {
        Method method;
        Class implClass;
        String beanName = fragmentDefinition.getImplementationBeanName();
        if (registry.containsBeanDefinition(beanName)) {
            return;
        }
        ((AbstractBeanDefinition)fragmentDefinition.getBeanDefinition()).setSource((Object)source);
        try {
            Class ifaceClass = ClassUtils.forName((String)fragmentDefinition.getInterfaceName(), (ClassLoader)((ConfigurableListableBeanFactory)registry).getBeanClassLoader());
            Class implClass2 = ClassUtils.forName((String)fragmentDefinition.getBeanDefinition().getBeanClassName(), (ClassLoader)((ConfigurableListableBeanFactory)registry).getBeanClassLoader());
            Class storeClass = ClassUtils.forName((String)fragmentDefinition.getStoreInterfaceName(), (ClassLoader)((ConfigurableListableBeanFactory)registry).getBeanClassLoader());
            Method method2 = ReflectionUtils.findMethod((Class)implClass2, (String)"setGenericArguments", (Class[])new Class[]{Class[].class});
            if (method2 != null) {
                List types = ClassTypeInformation.from((Class)storeClass).getSuperTypeInformation(ifaceClass).getTypeArguments();
                List<Class> genericArguments = types.stream().map(TypeInformation::getType).collect(Collectors.toList());
                fragmentDefinition.getBeanDefinition().getPropertyValues().add("genericArguments", (Object)genericArguments.toArray(new Class[0]));
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Failed setting fragment generic arguments", (Throwable)e);
        }
        try {
            implClass = ClassUtils.forName((String)fragmentDefinition.getBeanDefinition().getBeanClassName(), (ClassLoader)((ConfigurableListableBeanFactory)registry).getBeanClassLoader());
            method = ReflectionUtils.findMethod((Class)implClass, (String)"setDomainClass", (Class[])new Class[]{Class.class});
            if (method != null) {
                fragmentDefinition.getBeanDefinition().getPropertyValues().add(DOMAIN_CLASS_PROPERTY, domainClass);
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Failed setting fragment domain class", (Throwable)e);
        }
        try {
            implClass = ClassUtils.forName((String)fragmentDefinition.getBeanDefinition().getBeanClassName(), (ClassLoader)((ConfigurableListableBeanFactory)registry).getBeanClassLoader());
            method = ReflectionUtils.findMethod((Class)implClass, (String)"setIdClass", (Class[])new Class[]{Class.class});
            if (method != null) {
                fragmentDefinition.getBeanDefinition().getPropertyValues().add(ID_CLASS_PROPERTY, idClass);
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Failed setting fragment ID class", (Throwable)e);
        }
        registry.registerBeanDefinition(beanName, fragmentDefinition.getBeanDefinition());
    }

    private void registerStoreFragment(BeanDefinitionRegistry registry, AnnotationMetadata source, StoreFragmentDefinition fragmentDefinition) {
        String implementationBeanName = fragmentDefinition.getImplementationBeanName();
        String fragmentBeanName = fragmentDefinition.getFragmentBeanName();
        if (registry.containsBeanDefinition(fragmentBeanName)) {
            return;
        }
        BeanDefinitionBuilder fragmentBuilder = BeanDefinitionBuilder.genericBeanDefinition(StoreFragment.class);
        fragmentBuilder.addConstructorArgValue((Object)fragmentDefinition.getInterfaceName());
        fragmentBuilder.addConstructorArgReference(implementationBeanName);
        registry.registerBeanDefinition(fragmentBeanName, (BeanDefinition)ParsingUtils.getSourceBeanDefinition((BeanDefinitionBuilder)fragmentBuilder, (Object)source));
    }

    protected boolean multipleStoreImplementationsDetected() {
        boolean multipleModulesFound;
        boolean bl = multipleModulesFound = SpringFactoriesLoader.loadFactoryNames(AbstractStoreFactoryBean.class, (ClassLoader)this.resourceLoader.getClassLoader()).size() > 1;
        if (multipleModulesFound) {
            LOGGER.info((Object)"Multiple store modules detected.  Entering strict resolution mode");
        }
        return multipleModulesFound;
    }

    protected abstract Class<? extends Annotation> getAnnotation();

    protected abstract Class<?>[] getSignatureTypes();

    protected String getOverridePropertyValue() {
        return "";
    }

    private class IsCandidatePredicate
    implements Predicate<String> {
        private Class<?>[] additionalTypes;

        public IsCandidatePredicate(Class<?>[] additionalTypes) {
            this.additionalTypes = additionalTypes;
        }

        @Override
        public boolean test(String s) {
            if (Store.class.getName().equals(s) || AssociativeStore.class.getName().equals(s) || ContentStore.class.getName().equals(s) || s.startsWith("java.")) {
                return false;
            }
            for (Class<?> additionalType : this.additionalTypes) {
                if (!additionalType.getName().equals(s)) continue;
                return false;
            }
            return true;
        }
    }
}

