/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.commons.store.factory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.content.commons.property.PropertyPath;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.repository.events.AfterGetResourceEvent;
import org.springframework.content.commons.repository.events.AfterUnassociateEvent;
import org.springframework.content.commons.repository.events.AfterUnsetContentEvent;
import org.springframework.content.commons.repository.events.BeforeGetResourceEvent;
import org.springframework.content.commons.repository.events.BeforeSetContentEvent;
import org.springframework.content.commons.repository.events.BeforeUnassociateEvent;
import org.springframework.content.commons.store.AssociativeStore;
import org.springframework.content.commons.store.GetResourceParams;
import org.springframework.content.commons.store.StoreAccessException;
import org.springframework.content.commons.store.events.AfterAssociateEvent;
import org.springframework.content.commons.store.events.AfterGetContentEvent;
import org.springframework.content.commons.store.events.AfterSetContentEvent;
import org.springframework.content.commons.store.events.BeforeAssociateEvent;
import org.springframework.content.commons.store.events.BeforeGetContentEvent;
import org.springframework.content.commons.store.events.BeforeUnsetContentEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.io.Resource;

public class StoreImpl
implements ContentStore<Object, Serializable>,
org.springframework.content.commons.store.ContentStore<Object, Serializable> {
    private static final Log logger = LogFactory.getLog(StoreImpl.class);
    private final Store<Serializable> delegate;
    private final ApplicationEventPublisher publisher;
    private final Path copyContentRootPath;

    public StoreImpl(Store<Serializable> delegate, ApplicationEventPublisher publisher, Path copyContentRootPath) {
        this.delegate = delegate;
        this.publisher = publisher;
        this.copyContentRootPath = copyContentRootPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Object setContent(Object property, InputStream content) {
        File contentCopy;
        Object result;
        block29: {
            result = null;
            contentCopy = null;
            TeeInputStream contentCopyStream = null;
            try {
                contentCopy = Files.createTempFile(this.copyContentRootPath, "contentCopy", ".tmp", new FileAttribute[0]).toFile();
                contentCopyStream = new TeeInputStream(content, new FileOutputStream(contentCopy), true);
                BeforeSetContentEvent oldBefore = null;
                org.springframework.content.commons.store.events.BeforeSetContentEvent before = null;
                oldBefore = new BeforeSetContentEvent(property, this.delegate, (InputStream)((Object)contentCopyStream));
                this.publisher.publishEvent((ApplicationEvent)oldBefore);
                org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
                if (contentStore != null) {
                    before = new org.springframework.content.commons.store.events.BeforeSetContentEvent(property, contentStore, (InputStream)((Object)contentCopyStream));
                    this.publisher.publishEvent((ApplicationEvent)before);
                }
                if (oldBefore != null && oldBefore.getInputStream() != null && !oldBefore.getInputStream().equals((Object)contentCopyStream)) {
                    content = oldBefore.getInputStream();
                } else if (before != null && before.getInputStream() != null && !before.getInputStream().equals((Object)contentCopyStream)) {
                    content = before.getInputStream();
                } else if (contentCopyStream != null && contentCopyStream.isDirty()) {
                    while (contentCopyStream.read(new byte[4096]) != -1) {
                    }
                    content = new FileInputStream(contentCopy);
                }
                result = this.castToDeprecatedContentStore(this.delegate).setContent(property, content);
                org.springframework.content.commons.repository.events.AfterSetContentEvent oldAfter = new org.springframework.content.commons.repository.events.AfterSetContentEvent(result, this.delegate);
                oldAfter.setResult(result);
                this.publisher.publishEvent((ApplicationEvent)oldAfter);
                if (contentStore != null) {
                    AfterSetContentEvent after = new AfterSetContentEvent(result, contentStore);
                    after.setResult(result);
                    this.publisher.publishEvent((ApplicationEvent)after);
                }
                if (contentCopyStream == null) break block29;
            }
            catch (FileNotFoundException fileNotFoundException) {
                block30: {
                    fileNotFoundException.printStackTrace();
                    if (contentCopyStream == null) break block30;
                    IOUtils.closeQuietly(contentCopyStream);
                }
                if (contentCopy != null) {
                    try {
                        Files.deleteIfExists(contentCopy.toPath());
                    }
                    catch (IOException e) {
                        logger.error((Object)String.format("Unable to delete content copy %s", contentCopy.toPath()), (Throwable)e);
                    }
                }
            }
            catch (IOException ioException) {
                block31: {
                    ioException.printStackTrace();
                    if (contentCopyStream == null) break block31;
                    {
                        catch (Throwable throwable) {
                            if (contentCopyStream != null) {
                                IOUtils.closeQuietly(contentCopyStream);
                            }
                            if (contentCopy != null) {
                                try {
                                    Files.deleteIfExists(contentCopy.toPath());
                                }
                                catch (IOException e) {
                                    logger.error((Object)String.format("Unable to delete content copy %s", contentCopy.toPath()), (Throwable)e);
                                }
                            }
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly(contentCopyStream);
                }
                if (contentCopy != null) {
                    try {
                        Files.deleteIfExists(contentCopy.toPath());
                    }
                    catch (IOException e) {
                        logger.error((Object)String.format("Unable to delete content copy %s", contentCopy.toPath()), (Throwable)e);
                    }
                }
            }
            IOUtils.closeQuietly((InputStream)((Object)contentCopyStream));
        }
        if (contentCopy != null) {
            try {
                Files.deleteIfExists(contentCopy.toPath());
            }
            catch (IOException e) {
                logger.error((Object)String.format("Unable to delete content copy %s", contentCopy.toPath()), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public Object setContent(Object property, PropertyPath propertyPath, InputStream content) {
        return this.setContent(property, propertyPath, content, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Object setContent(Object property, PropertyPath propertyPath, InputStream content, long contentLen) {
        File contentCopy;
        Object result;
        block29: {
            result = null;
            contentCopy = null;
            TeeInputStream contentCopyStream = null;
            try {
                contentCopy = Files.createTempFile(this.copyContentRootPath, "contentCopy", ".tmp", new FileAttribute[0]).toFile();
                contentCopyStream = new TeeInputStream(content, new FileOutputStream(contentCopy), true);
                BeforeSetContentEvent oldBefore = null;
                org.springframework.content.commons.store.events.BeforeSetContentEvent before = null;
                oldBefore = new BeforeSetContentEvent(property, propertyPath, this.delegate, (InputStream)((Object)contentCopyStream));
                this.publisher.publishEvent((ApplicationEvent)oldBefore);
                org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
                if (contentStore != null) {
                    before = new org.springframework.content.commons.store.events.BeforeSetContentEvent(property, propertyPath, contentStore, (InputStream)((Object)contentCopyStream));
                    this.publisher.publishEvent((ApplicationEvent)before);
                }
                if (oldBefore != null && oldBefore.getInputStream() != null && !oldBefore.getInputStream().equals((Object)contentCopyStream)) {
                    content = oldBefore.getInputStream();
                } else if (before != null && before.getInputStream() != null && !before.getInputStream().equals((Object)contentCopyStream)) {
                    content = before.getInputStream();
                } else if (contentCopyStream != null && contentCopyStream.isDirty()) {
                    while (contentCopyStream.read(new byte[4096]) != -1) {
                    }
                    content = new FileInputStream(contentCopy);
                }
                result = this.castToDeprecatedContentStore(this.delegate).setContent(property, propertyPath, content, contentLen);
                org.springframework.content.commons.repository.events.AfterSetContentEvent oldAfter = new org.springframework.content.commons.repository.events.AfterSetContentEvent(property, propertyPath, this.delegate);
                oldAfter.setResult(result);
                this.publisher.publishEvent((ApplicationEvent)oldAfter);
                if (contentStore != null) {
                    AfterSetContentEvent after = new AfterSetContentEvent(property, propertyPath, contentStore);
                    after.setResult(result);
                    this.publisher.publishEvent((ApplicationEvent)after);
                }
                if (contentCopyStream == null) break block29;
            }
            catch (FileNotFoundException fileNotFoundException) {
                block30: {
                    fileNotFoundException.printStackTrace();
                    if (contentCopyStream == null) break block30;
                    IOUtils.closeQuietly(contentCopyStream);
                }
                if (contentCopy != null) {
                    try {
                        Files.deleteIfExists(contentCopy.toPath());
                    }
                    catch (IOException e) {
                        logger.error((Object)String.format("Unable to delete content copy %s", contentCopy.toPath()), (Throwable)e);
                    }
                }
            }
            catch (IOException ioException) {
                block31: {
                    ioException.printStackTrace();
                    if (contentCopyStream == null) break block31;
                    {
                        catch (Throwable throwable) {
                            if (contentCopyStream != null) {
                                IOUtils.closeQuietly(contentCopyStream);
                            }
                            if (contentCopy != null) {
                                try {
                                    Files.deleteIfExists(contentCopy.toPath());
                                }
                                catch (IOException e) {
                                    logger.error((Object)String.format("Unable to delete content copy %s", contentCopy.toPath()), (Throwable)e);
                                }
                            }
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly(contentCopyStream);
                }
                if (contentCopy != null) {
                    try {
                        Files.deleteIfExists(contentCopy.toPath());
                    }
                    catch (IOException e) {
                        logger.error((Object)String.format("Unable to delete content copy %s", contentCopy.toPath()), (Throwable)e);
                    }
                }
            }
            IOUtils.closeQuietly((InputStream)((Object)contentCopyStream));
        }
        if (contentCopy != null) {
            try {
                Files.deleteIfExists(contentCopy.toPath());
            }
            catch (IOException e) {
                logger.error((Object)String.format("Unable to delete content copy %s", contentCopy.toPath()), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public Object setContent(Object property, Resource resourceContent) {
        BeforeSetContentEvent oldBefore = new BeforeSetContentEvent(property, this.delegate, resourceContent);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.BeforeSetContentEvent before = new org.springframework.content.commons.store.events.BeforeSetContentEvent(property, contentStore, resourceContent);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        Object result = this.castToDeprecatedContentStore(this.delegate).setContent(property, resourceContent);
        org.springframework.content.commons.repository.events.AfterSetContentEvent oldAfter = new org.springframework.content.commons.repository.events.AfterSetContentEvent(property, this.delegate);
        oldAfter.setResult(result);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (contentStore != null) {
            AfterSetContentEvent after = new AfterSetContentEvent(property, contentStore);
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
        return result;
    }

    @Override
    public Object setContent(Object property, PropertyPath propertyPath, Resource resourceContent) {
        BeforeSetContentEvent oldBefore = new BeforeSetContentEvent(property, propertyPath, this.delegate, resourceContent);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.BeforeSetContentEvent before = new org.springframework.content.commons.store.events.BeforeSetContentEvent(property, propertyPath, contentStore, resourceContent);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        Object result = this.castToDeprecatedContentStore(this.delegate).setContent(property, propertyPath, resourceContent);
        org.springframework.content.commons.repository.events.AfterSetContentEvent oldAfter = new org.springframework.content.commons.repository.events.AfterSetContentEvent(property, propertyPath, this.delegate);
        oldAfter.setResult(result);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (contentStore != null) {
            AfterSetContentEvent after = new AfterSetContentEvent(property, propertyPath, contentStore);
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
        return result;
    }

    @Override
    public Object unsetContent(Object property) {
        org.springframework.content.commons.repository.events.BeforeUnsetContentEvent oldBefore = new org.springframework.content.commons.repository.events.BeforeUnsetContentEvent(property, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            BeforeUnsetContentEvent before = new BeforeUnsetContentEvent(property, contentStore);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        Object result = this.castToDeprecatedContentStore(this.delegate).unsetContent(property);
        AfterUnsetContentEvent oldAfter = new AfterUnsetContentEvent(property, this.delegate);
        oldAfter.setResult(result);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.AfterUnsetContentEvent after = new org.springframework.content.commons.store.events.AfterUnsetContentEvent(property, contentStore);
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
        return result;
    }

    @Override
    public Object unsetContent(Object property, PropertyPath propertyPath) {
        org.springframework.content.commons.repository.events.BeforeUnsetContentEvent oldBefore = new org.springframework.content.commons.repository.events.BeforeUnsetContentEvent(property, propertyPath, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            BeforeUnsetContentEvent before = new BeforeUnsetContentEvent(property, propertyPath, contentStore);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        Object result = this.castToDeprecatedContentStore(this.delegate).unsetContent(property, propertyPath);
        AfterUnsetContentEvent oldAfter = new AfterUnsetContentEvent(property, propertyPath, this.delegate);
        oldAfter.setResult(result);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.AfterUnsetContentEvent after = new org.springframework.content.commons.store.events.AfterUnsetContentEvent(property, propertyPath, contentStore);
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
        return result;
    }

    @Override
    public InputStream getContent(Object property) {
        org.springframework.content.commons.repository.events.BeforeGetContentEvent oldBefore = new org.springframework.content.commons.repository.events.BeforeGetContentEvent(property, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            BeforeGetContentEvent before = new BeforeGetContentEvent(property, contentStore);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        InputStream result = this.castToDeprecatedContentStore(this.delegate).getContent(property);
        org.springframework.content.commons.repository.events.AfterGetContentEvent oldAfter = new org.springframework.content.commons.repository.events.AfterGetContentEvent(property, this.delegate);
        oldAfter.setResult(result);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (contentStore != null) {
            AfterGetContentEvent after = new AfterGetContentEvent(property, contentStore);
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
        return result;
    }

    @Override
    public InputStream getContent(Object property, PropertyPath propertyPath) {
        org.springframework.content.commons.repository.events.BeforeGetContentEvent oldBefore = new org.springframework.content.commons.repository.events.BeforeGetContentEvent(property, propertyPath, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            BeforeGetContentEvent before = new BeforeGetContentEvent(property, propertyPath, contentStore);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        InputStream result = this.castToDeprecatedContentStore(this.delegate).getContent(property, propertyPath);
        org.springframework.content.commons.repository.events.AfterGetContentEvent oldAfter = new org.springframework.content.commons.repository.events.AfterGetContentEvent(property, propertyPath, this.delegate);
        oldAfter.setResult(result);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (oldAfter.getResult() != null) {
            result = (InputStream)oldAfter.getResult();
        }
        if (contentStore != null) {
            AfterGetContentEvent after = new AfterGetContentEvent(property, propertyPath, contentStore);
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
            if (after.getResult() != null) {
                result = (InputStream)after.getResult();
            }
        }
        return result;
    }

    @Override
    public Resource getResource(Object entity) {
        BeforeGetResourceEvent oldBefore = new BeforeGetResourceEvent(entity, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.BeforeGetResourceEvent before = new org.springframework.content.commons.store.events.BeforeGetResourceEvent(entity, contentStore);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        Resource result = this.castToDeprecatedContentStore(this.delegate).getResource(entity);
        AfterGetResourceEvent oldAfter = new AfterGetResourceEvent(entity, this.delegate);
        oldAfter.setResult(result);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.AfterGetResourceEvent after = new org.springframework.content.commons.store.events.AfterGetResourceEvent(entity, contentStore);
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
        return result;
    }

    @Override
    public Resource getResource(Object entity, PropertyPath propertyPath) {
        BeforeGetResourceEvent oldBefore = new BeforeGetResourceEvent(entity, propertyPath, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.BeforeGetResourceEvent before = new org.springframework.content.commons.store.events.BeforeGetResourceEvent(entity, propertyPath, contentStore);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        Resource result = this.castToDeprecatedContentStore(this.delegate).getResource(entity, propertyPath);
        AfterGetResourceEvent oldAfter = new AfterGetResourceEvent(entity, propertyPath, this.delegate);
        oldAfter.setResult(result);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (oldAfter.getResult() != null) {
            result = (Resource)oldAfter.getResult();
        }
        if (contentStore != null) {
            org.springframework.content.commons.store.events.AfterGetResourceEvent after = new org.springframework.content.commons.store.events.AfterGetResourceEvent(entity, propertyPath, contentStore);
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
            if (after.getStore() != null) {
                result = (Resource)after.getResult();
            }
        }
        return result;
    }

    @Override
    public Resource getResource(Object entity, PropertyPath propertyPath, org.springframework.content.commons.repository.GetResourceParams oldParams) {
        BeforeGetResourceEvent oldBefore = new BeforeGetResourceEvent(entity, propertyPath, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.BeforeGetResourceEvent before = new org.springframework.content.commons.store.events.BeforeGetResourceEvent(entity, propertyPath, contentStore);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        Resource result = this.castToDeprecatedContentStore(this.delegate).getResource(entity, propertyPath, oldParams);
        AfterGetResourceEvent oldAfter = new AfterGetResourceEvent(entity, propertyPath, this.delegate);
        oldAfter.setResult(result);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (oldAfter.getResult() != null) {
            result = (Resource)oldAfter.getResult();
        }
        if (contentStore != null) {
            org.springframework.content.commons.store.events.AfterGetResourceEvent after = new org.springframework.content.commons.store.events.AfterGetResourceEvent(entity, propertyPath, contentStore);
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
            if (after.getResult() != null) {
                result = (Resource)after.getResult();
            }
        }
        return result;
    }

    @Override
    public Resource getResource(Object entity, PropertyPath propertyPath, GetResourceParams params) {
        BeforeGetResourceEvent oldBefore = new BeforeGetResourceEvent(entity, propertyPath, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.BeforeGetResourceEvent before = new org.springframework.content.commons.store.events.BeforeGetResourceEvent(entity, propertyPath, contentStore);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        Resource result = ((AssociativeStore)this.delegate).getResource(entity, propertyPath, params);
        AfterGetResourceEvent oldAfter = new AfterGetResourceEvent(entity, propertyPath, this.delegate);
        oldAfter.setResult(result);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (oldAfter.getResult() != null) {
            result = (Resource)oldAfter.getResult();
        }
        if (contentStore != null) {
            org.springframework.content.commons.store.events.AfterGetResourceEvent after = new org.springframework.content.commons.store.events.AfterGetResourceEvent(entity, propertyPath, contentStore);
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
            if (after.getStore() != null) {
                result = (Resource)after.getResult();
            }
        }
        return result;
    }

    @Override
    public Resource getResource(Serializable id) {
        BeforeGetResourceEvent oldBefore = new BeforeGetResourceEvent(id, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.BeforeGetResourceEvent before = new org.springframework.content.commons.store.events.BeforeGetResourceEvent((Object)id, contentStore);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        Resource result = this.castToDeprecatedContentStore(this.delegate).getResource(id);
        AfterGetResourceEvent oldAfter = new AfterGetResourceEvent(id, this.delegate);
        oldAfter.setResult(result);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.AfterGetResourceEvent after = new org.springframework.content.commons.store.events.AfterGetResourceEvent((Object)id, contentStore);
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
        return result;
    }

    @Override
    public void associate(Object entity, Serializable id) {
        org.springframework.content.commons.repository.events.BeforeAssociateEvent oldBefore = new org.springframework.content.commons.repository.events.BeforeAssociateEvent(entity, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            BeforeAssociateEvent before = new BeforeAssociateEvent(entity, contentStore);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        this.castToDeprecatedContentStore(this.delegate).associate(entity, id);
        org.springframework.content.commons.repository.events.AfterAssociateEvent oldAfter = new org.springframework.content.commons.repository.events.AfterAssociateEvent(entity, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (contentStore != null) {
            AfterAssociateEvent after = new AfterAssociateEvent(entity, contentStore);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
    }

    @Override
    public void associate(Object entity, PropertyPath propertyPath, Serializable id) {
        org.springframework.content.commons.repository.events.BeforeAssociateEvent oldBefore = new org.springframework.content.commons.repository.events.BeforeAssociateEvent(entity, propertyPath, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            BeforeAssociateEvent before = new BeforeAssociateEvent(entity, propertyPath, contentStore);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        this.castToDeprecatedContentStore(this.delegate).associate(entity, propertyPath, id);
        org.springframework.content.commons.repository.events.AfterAssociateEvent oldAfter = new org.springframework.content.commons.repository.events.AfterAssociateEvent(entity, propertyPath, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (contentStore != null) {
            AfterAssociateEvent after = new AfterAssociateEvent(entity, propertyPath, contentStore);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
    }

    @Override
    public void unassociate(Object entity) {
        BeforeUnassociateEvent oldBefore = new BeforeUnassociateEvent(entity, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.BeforeUnassociateEvent before = new org.springframework.content.commons.store.events.BeforeUnassociateEvent(entity, contentStore);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        this.castToDeprecatedContentStore(this.delegate).unassociate(entity);
        AfterUnassociateEvent oldAfter = new AfterUnassociateEvent(entity, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.AfterUnassociateEvent after = new org.springframework.content.commons.store.events.AfterUnassociateEvent(entity, contentStore);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
    }

    @Override
    public void unassociate(Object entity, PropertyPath propertyPath) {
        BeforeUnassociateEvent oldBefore = new BeforeUnassociateEvent(entity, propertyPath, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.BeforeUnassociateEvent before = new org.springframework.content.commons.store.events.BeforeUnassociateEvent(entity, propertyPath, contentStore);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        this.castToDeprecatedContentStore(this.delegate).unassociate(entity, propertyPath);
        AfterUnassociateEvent oldAfter = new AfterUnassociateEvent(entity, propertyPath, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.AfterUnassociateEvent after = new org.springframework.content.commons.store.events.AfterUnassociateEvent(entity, propertyPath, contentStore);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
    }

    private <SID extends Serializable> ContentStore<Object, SID> castToDeprecatedContentStore(Store<Serializable> delegate) {
        if (!(delegate instanceof ContentStore)) {
            throw new StoreAccessException("store does not implement org.springframework.content.commons.repository.ContentStore");
        }
        return (ContentStore)delegate;
    }

    private <SID extends Serializable> org.springframework.content.commons.store.ContentStore<Object, SID> castToContentStore(Store<Serializable> delegate) {
        if (!(delegate instanceof org.springframework.content.commons.store.ContentStore)) {
            return null;
        }
        return (org.springframework.content.commons.store.ContentStore)delegate;
    }

    static class TeeInputStream
    extends org.apache.commons.io.input.TeeInputStream {
        private boolean isDirty = false;

        public TeeInputStream(InputStream input, OutputStream branch, boolean closeBranch) {
            super(input, branch, closeBranch);
        }

        public int read() throws IOException {
            this.isDirty = true;
            return super.read();
        }

        public int read(byte[] bts, int st, int end) throws IOException {
            this.isDirty = true;
            return super.read(bts, st, end);
        }

        public int read(byte[] bts) throws IOException {
            this.isDirty = true;
            return super.read(bts);
        }

        public void close() throws IOException {
            super.close();
        }

        public boolean isDirty() {
            return this.isDirty;
        }
    }
}

