/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.commons.store.factory;

import internal.org.springframework.content.commons.config.StoreFragment;
import internal.org.springframework.content.commons.config.StoreFragments;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.content.commons.fragments.ContentStoreAware;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;

public class StoreMethodInterceptor
implements MethodInterceptor {
    private static final Log LOGGER = LogFactory.getLog(StoreMethodInterceptor.class);
    private StoreFragments storeFragments;
    private Map<Method, Method> methodCache = new ConcurrentReferenceHashMap();
    private static Method setContentStoreMethod = ReflectionUtils.findMethod(ContentStoreAware.class, (String)"setContentStore", (Class[])new Class[]{ContentStore.class});

    public void setStoreFragments(StoreFragments storeFragments) {
        this.storeFragments = storeFragments;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.storeFragments != null) {
            Optional<StoreFragment> fragment = this.storeFragments.stream().filter(it -> it.hasMethod(invocation.getMethod())).findFirst();
            if (!fragment.isPresent()) {
                fragment = this.storeFragments.stream().filter(it -> it.hasImplementationMethod(invocation.getMethod())).findFirst();
            }
            fragment.orElseThrow(() -> new IllegalStateException(String.format("No fragment found for method %s", invocation.getMethod())));
            StoreFragment f = fragment.get();
            if (f.hasImplementationMethod(setContentStoreMethod)) {
                ReflectionUtils.invokeMethod((Method)setContentStoreMethod, f.getImplementation(), (Object[])new Object[]{invocation.getThis()});
            }
            try {
                return this.getMethod(invocation.getMethod(), f).invoke(fragment.get().getImplementation(), invocation.getArguments());
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }
        String msg = String.format("No fragment implementation found for invoked method %s", invocation);
        LOGGER.error((Object)msg, (Throwable)new UnsupportedOperationException(msg));
        return null;
    }

    Method getMethod(Method invokedMethod, StoreFragment fragment) {
        return this.methodCache.computeIfAbsent(invokedMethod, key -> this.resolveImplementationMethod(invokedMethod, fragment));
    }

    private Method resolveImplementationMethod(Method invokedMethod, StoreFragment fragment) {
        if (invokedMethod.getName().equals("getResource") && Serializable.class.isAssignableFrom(invokedMethod.getParameterTypes()[0])) {
            return ReflectionUtils.findMethod(fragment.getImplementation().getClass(), (String)"getResource", (Class[])new Class[]{Serializable.class});
        }
        for (Method candidate : fragment.getImplementation().getClass().getMethods()) {
            if (!invokedMethod.getName().equals(candidate.getName()) || !this.parametersMatch(invokedMethod, candidate)) continue;
            return candidate;
        }
        return null;
    }

    private boolean parametersMatch(Method invokedMethod, Method candidate) {
        if (invokedMethod.getParameterCount() != candidate.getParameterCount()) {
            return false;
        }
        Class<?>[] invokedMethodTypes = invokedMethod.getParameterTypes();
        Class<?>[] candidateMethodTypes = candidate.getParameterTypes();
        for (int i = 0; i < invokedMethod.getParameterCount(); ++i) {
            if (candidateMethodTypes[i].isAssignableFrom(invokedMethodTypes[i])) continue;
            return false;
        }
        return true;
    }

    static {
        Assert.notNull((Object)setContentStoreMethod);
    }
}

