/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.commons.mappingcontext;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.content.commons.mappingcontext.ClassVisitor;
import org.springframework.content.commons.utils.ContentPropertyUtils;
import org.springframework.util.StringUtils;

public class ClassWalker {
    private static final Log LOGGER = LogFactory.getLog(ClassWalker.class);
    private ClassVisitor visitor;

    public ClassWalker(ClassVisitor visitor) {
        this.visitor = visitor;
    }

    public void accept(Class<?> klazz) {
        boolean fContinue = true;
        Stack<WalkContext> classStack = new Stack<WalkContext>();
        if (!(fContinue &= this.visitor.visitClass("", klazz))) {
            return;
        }
        List<Field> fields = new ArrayList<Field>();
        fields = this.getAllFields(fields, klazz);
        for (Field field : fields) {
            fContinue &= this.visitor.visitFieldBefore("", klazz, field);
            fContinue &= this.visitor.visitField("", klazz, field);
            if (this.isObject(field) && !this.contains(classStack, field.getType())) {
                classStack.push(new WalkContext(field.getName(), field.getType()));
                this.accept(field.getType(), classStack);
                classStack.pop();
            }
            fContinue &= this.visitor.visitFieldAfter("", klazz, field);
        }
        if (!fContinue) {
            return;
        }
        if (!fContinue) {
            return;
        }
        this.visitor.visitClassEnd("", klazz);
    }

    public void accept(Class<?> klazz, Stack<WalkContext> classStack) {
        boolean fContinue = true;
        WalkContext context = classStack.peek();
        if (!(fContinue &= this.visitor.visitClass(context.getPath(), klazz))) {
            return;
        }
        List<Field> fields = new ArrayList<Field>();
        fields = this.getAllFields(fields, context.getClazz());
        for (Field field : fields) {
            fContinue &= this.visitor.visitFieldBefore("", klazz, field);
            fContinue &= this.visitor.visitField(context.getPath(), klazz, field);
            if (this.isObject(field) && !this.contains(classStack, field.getType())) {
                String path = field.getName();
                if (StringUtils.hasLength((String)context.getPath())) {
                    path = String.format("%s/%s", context.getPath(), path);
                }
                classStack.push(new WalkContext(path, field.getType()));
                this.accept(field.getType(), classStack);
                classStack.pop();
            }
            fContinue &= this.visitor.visitFieldAfter("", klazz, field);
        }
        if (!fContinue) {
            return;
        }
        if (!fContinue) {
            return;
        }
        this.visitor.visitClassEnd(context.getPath(), klazz);
    }

    private boolean contains(Stack<WalkContext> classStack, Class<?> type) {
        for (WalkContext context : classStack) {
            if (!context.getClazz().equals(type)) continue;
            return true;
        }
        return false;
    }

    private boolean isObject(Field field) {
        return !field.getType().isPrimitive() && !field.getType().equals(String.class) && !field.getType().equals(UUID.class) && !field.getType().isEnum() && !ContentPropertyUtils.isWrapperType(field.getType()) && !ContentPropertyUtils.isRelationshipField(field);
    }

    private List<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            this.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    public static class WalkContext {
        private String path;
        private Class<?> clazz;

        public String getPath() {
            return this.path;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public WalkContext(String path, Class<?> clazz) {
            this.path = path;
            this.clazz = clazz;
        }
    }
}

