/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.commons.mappingcontext;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.content.commons.mappingcontext.Condition;
import org.springframework.core.convert.TypeDescriptor;

public class ContentProperty {
    private String contentPropertyPath;
    private String contentIdPropertyPath;
    private String contentLengthPropertyPath;
    private String mimeTypePropertyPath;
    private String originalFileNamePropertyPath;

    public Object getCustomProperty(Object entity, String propertyName) {
        String customContentPropertyPath = this.contentPropertyPath + StringUtils.capitalize((String)propertyName);
        BeanWrapperImpl wrapper = new BeanWrapperImpl(entity);
        return wrapper.getPropertyValue(customContentPropertyPath);
    }

    public void setCustomProperty(Object entity, String propertyName, Object value) {
        String customContentPropertyPath = this.contentPropertyPath + StringUtils.capitalize((String)propertyName);
        BeanWrapperImpl wrapper = new BeanWrapperImpl(entity);
        wrapper.setPropertyValue(customContentPropertyPath, value);
    }

    public Object getContentId(Object entity) {
        if (this.contentLengthPropertyPath == null) {
            return null;
        }
        BeanWrapperImpl wrapper = new BeanWrapperImpl(entity);
        return wrapper.getPropertyValue(this.contentIdPropertyPath);
    }

    public void setContentId(Object entity, Object value, Condition condition) {
        TypeDescriptor t;
        if (this.contentIdPropertyPath == null) {
            return;
        }
        BeanWrapperImpl wrapper = new BeanWrapperImpl(entity);
        if (condition != null && !condition.matches(t = wrapper.getPropertyTypeDescriptor(this.contentIdPropertyPath))) {
            return;
        }
        wrapper.setPropertyValue(this.contentIdPropertyPath, value);
    }

    public TypeDescriptor getContentIdType(Object entity) {
        if (this.contentIdPropertyPath == null) {
            return null;
        }
        BeanWrapperImpl wrapper = new BeanWrapperImpl(entity);
        return wrapper.getPropertyTypeDescriptor(this.contentIdPropertyPath);
    }

    public Object getContentLength(Object entity) {
        if (this.contentLengthPropertyPath == null) {
            return 0L;
        }
        BeanWrapperImpl wrapper = new BeanWrapperImpl(entity);
        return wrapper.getPropertyValue(this.contentLengthPropertyPath);
    }

    public void setContentLength(Object entity, Object value) {
        if (this.contentLengthPropertyPath == null) {
            return;
        }
        BeanWrapperImpl wrapper = new BeanWrapperImpl(entity);
        wrapper.setPropertyValue(this.contentLengthPropertyPath, value);
    }

    public Object getMimeType(Object entity) {
        if (this.mimeTypePropertyPath == null) {
            return null;
        }
        BeanWrapperImpl wrapper = new BeanWrapperImpl(entity);
        return wrapper.getPropertyValue(this.mimeTypePropertyPath);
    }

    public void setMimeType(Object entity, Object value) {
        if (this.mimeTypePropertyPath == null) {
            return;
        }
        BeanWrapperImpl wrapper = new BeanWrapperImpl(entity);
        wrapper.setPropertyValue(this.mimeTypePropertyPath, value);
    }

    public void setOriginalFileName(Object entity, Object value) {
        if (this.originalFileNamePropertyPath == null) {
            return;
        }
        BeanWrapperImpl wrapper = new BeanWrapperImpl(entity);
        wrapper.setPropertyValue(this.originalFileNamePropertyPath, value);
    }

    public Object getOriginalFileName(Object entity) {
        if (this.originalFileNamePropertyPath == null) {
            return null;
        }
        BeanWrapperImpl wrapper = new BeanWrapperImpl(entity);
        return wrapper.getPropertyValue(this.originalFileNamePropertyPath);
    }

    public String getContentPropertyPath() {
        return this.contentPropertyPath;
    }

    public String getContentIdPropertyPath() {
        return this.contentIdPropertyPath;
    }

    public String getContentLengthPropertyPath() {
        return this.contentLengthPropertyPath;
    }

    public String getMimeTypePropertyPath() {
        return this.mimeTypePropertyPath;
    }

    public String getOriginalFileNamePropertyPath() {
        return this.originalFileNamePropertyPath;
    }

    public void setContentPropertyPath(String contentPropertyPath) {
        this.contentPropertyPath = contentPropertyPath;
    }

    public void setContentIdPropertyPath(String contentIdPropertyPath) {
        this.contentIdPropertyPath = contentIdPropertyPath;
    }

    public void setContentLengthPropertyPath(String contentLengthPropertyPath) {
        this.contentLengthPropertyPath = contentLengthPropertyPath;
    }

    public void setMimeTypePropertyPath(String mimeTypePropertyPath) {
        this.mimeTypePropertyPath = mimeTypePropertyPath;
    }

    public void setOriginalFileNamePropertyPath(String originalFileNamePropertyPath) {
        this.originalFileNamePropertyPath = originalFileNamePropertyPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentProperty)) {
            return false;
        }
        ContentProperty other = (ContentProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$contentPropertyPath = this.getContentPropertyPath();
        String other$contentPropertyPath = other.getContentPropertyPath();
        if (this$contentPropertyPath == null ? other$contentPropertyPath != null : !this$contentPropertyPath.equals(other$contentPropertyPath)) {
            return false;
        }
        String this$contentIdPropertyPath = this.getContentIdPropertyPath();
        String other$contentIdPropertyPath = other.getContentIdPropertyPath();
        if (this$contentIdPropertyPath == null ? other$contentIdPropertyPath != null : !this$contentIdPropertyPath.equals(other$contentIdPropertyPath)) {
            return false;
        }
        String this$contentLengthPropertyPath = this.getContentLengthPropertyPath();
        String other$contentLengthPropertyPath = other.getContentLengthPropertyPath();
        if (this$contentLengthPropertyPath == null ? other$contentLengthPropertyPath != null : !this$contentLengthPropertyPath.equals(other$contentLengthPropertyPath)) {
            return false;
        }
        String this$mimeTypePropertyPath = this.getMimeTypePropertyPath();
        String other$mimeTypePropertyPath = other.getMimeTypePropertyPath();
        if (this$mimeTypePropertyPath == null ? other$mimeTypePropertyPath != null : !this$mimeTypePropertyPath.equals(other$mimeTypePropertyPath)) {
            return false;
        }
        String this$originalFileNamePropertyPath = this.getOriginalFileNamePropertyPath();
        String other$originalFileNamePropertyPath = other.getOriginalFileNamePropertyPath();
        return !(this$originalFileNamePropertyPath == null ? other$originalFileNamePropertyPath != null : !this$originalFileNamePropertyPath.equals(other$originalFileNamePropertyPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContentProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $contentPropertyPath = this.getContentPropertyPath();
        result = result * 59 + ($contentPropertyPath == null ? 43 : $contentPropertyPath.hashCode());
        String $contentIdPropertyPath = this.getContentIdPropertyPath();
        result = result * 59 + ($contentIdPropertyPath == null ? 43 : $contentIdPropertyPath.hashCode());
        String $contentLengthPropertyPath = this.getContentLengthPropertyPath();
        result = result * 59 + ($contentLengthPropertyPath == null ? 43 : $contentLengthPropertyPath.hashCode());
        String $mimeTypePropertyPath = this.getMimeTypePropertyPath();
        result = result * 59 + ($mimeTypePropertyPath == null ? 43 : $mimeTypePropertyPath.hashCode());
        String $originalFileNamePropertyPath = this.getOriginalFileNamePropertyPath();
        result = result * 59 + ($originalFileNamePropertyPath == null ? 43 : $originalFileNamePropertyPath.hashCode());
        return result;
    }
}

