/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.commons.mappingcontext;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.annotations.ContentLength;
import org.springframework.content.commons.annotations.MimeType;
import org.springframework.content.commons.annotations.OriginalFileName;
import org.springframework.content.commons.mappingcontext.ClassVisitor;
import org.springframework.content.commons.mappingcontext.ContentProperty;
import org.springframework.util.StringUtils;

public class ContentPropertyMappingContextVisitor
implements ClassVisitor {
    private static final Log LOGGER = LogFactory.getLog(ContentPropertyMappingContextVisitor.class);
    private Map<Class<?>, Boolean> looseModes = new HashMap();
    private Map<String, Map<String, ContentProperty>> properties = new HashMap<String, Map<String, ContentProperty>>();
    private CharSequence keySeparator;
    private CharSequence contentPropertySeparator;

    public ContentPropertyMappingContextVisitor(CharSequence keySeparator, CharSequence contentPropertySeparator) {
        this.keySeparator = keySeparator;
        this.contentPropertySeparator = contentPropertySeparator;
    }

    public Map<String, ContentProperty> getProperties() {
        HashMap<String, ContentProperty> props = new HashMap<String, ContentProperty>();
        for (Map<String, ContentProperty> property : this.properties.values()) {
            props.putAll(property);
        }
        return props;
    }

    @Override
    public boolean visitClass(String path, Class<?> klazz) {
        this.properties.put(this.key(path, klazz), new HashMap());
        int numContentIds = 0;
        for (Field field : klazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ContentId.class)) continue;
            ++numContentIds;
        }
        this.looseModes.put(klazz, numContentIds == 1);
        LOGGER.trace((Object)String.format("Loose mode enabled: %s", this.looseModes.get(klazz)));
        return true;
    }

    private String key(String path, Class<?> klazz) {
        return klazz.getCanonicalName() + "." + path;
    }

    @Override
    public boolean visitClassEnd(String path, Class<?> klazz) {
        boolean looseMode = this.looseModes.get(klazz);
        Map<String, ContentProperty> props = this.properties.get(this.key(path, klazz));
        if (looseMode && props.size() >= 1) {
            LOGGER.trace((Object)String.format("Loose mode enabled. Collapsing properties for %s", klazz.getCanonicalName()));
            ContentProperty contentProperty = new ContentProperty();
            for (ContentProperty property : props.values()) {
                if (property.getContentIdPropertyPath() != null) {
                    contentProperty.setContentPropertyPath(property.getContentPropertyPath());
                    contentProperty.setContentIdPropertyPath(property.getContentIdPropertyPath());
                }
                if (property.getContentLengthPropertyPath() != null) {
                    contentProperty.setContentLengthPropertyPath(property.getContentLengthPropertyPath());
                }
                if (property.getMimeTypePropertyPath() != null) {
                    contentProperty.setMimeTypePropertyPath(property.getMimeTypePropertyPath());
                }
                if (property.getOriginalFileNamePropertyPath() == null) continue;
                contentProperty.setOriginalFileNamePropertyPath(property.getOriginalFileNamePropertyPath());
            }
            HashMap<String, ContentProperty> newClassProps = new HashMap<String, ContentProperty>();
            this.properties.put(this.key(path, klazz), newClassProps);
            if (this.isNotRootContentProperty(path)) {
                newClassProps.put(path, contentProperty);
            } else {
                newClassProps.put(contentProperty.getContentPropertyPath(), contentProperty);
            }
        }
        return true;
    }

    @Override
    public boolean visitField(String path, Class<?> klazz, Field f) {
        LOGGER.trace((Object)String.format("Visiting %s.%s", f.getDeclaringClass().getCanonicalName(), f.getName()));
        if (f.isAnnotationPresent(ContentId.class)) {
            LOGGER.trace((Object)String.format("%s.%s is @ContentId", f.getDeclaringClass().getCanonicalName(), f.getName()));
            String propertyName = this.fullyQualify(path, this.propertyName(f.getName()), this.getKeySeparator());
            if (StringUtils.hasLength((String)propertyName)) {
                Map<String, ContentProperty> classProperties = this.properties.get(this.key(path, klazz));
                ContentProperty property = classProperties.get(propertyName);
                if (property == null) {
                    property = new ContentProperty();
                    classProperties.put(propertyName, property);
                }
                this.updateContentProperty(property::setContentPropertyPath, this.fullyQualify(path, this.propertyName(f.getName()), this.getContentPropertySeparator()));
                this.updateContentProperty(property::setContentIdPropertyPath, this.fullyQualify(path, f.getName(), this.getContentPropertySeparator()));
            }
        } else if (f.isAnnotationPresent(ContentLength.class)) {
            LOGGER.trace((Object)String.format("%s.%s is @ContentLength", f.getDeclaringClass().getCanonicalName(), f.getName()));
            String propertyName = this.fullyQualify(path, this.propertyName(f.getName()), this.getKeySeparator());
            if (StringUtils.hasLength((String)propertyName)) {
                Map<String, ContentProperty> classProperties = this.properties.get(this.key(path, klazz));
                ContentProperty property = classProperties.get(propertyName);
                if (property == null) {
                    property = new ContentProperty();
                    classProperties.put(propertyName, property);
                }
                this.updateContentProperty(property::setContentLengthPropertyPath, this.fullyQualify(path, f.getName(), this.getContentPropertySeparator()));
            }
        } else if (f.isAnnotationPresent(MimeType.class)) {
            LOGGER.trace((Object)String.format("%s.%s is @MimeType", f.getDeclaringClass().getCanonicalName(), f.getName()));
            String propertyName = this.fullyQualify(path, this.propertyName(f.getName()), this.getKeySeparator());
            if (StringUtils.hasLength((String)propertyName)) {
                Map<String, ContentProperty> classProperties = this.properties.get(this.key(path, klazz));
                ContentProperty property = classProperties.get(propertyName);
                if (property == null) {
                    property = new ContentProperty();
                    classProperties.put(propertyName, property);
                }
                this.updateContentProperty(property::setMimeTypePropertyPath, this.fullyQualify(path, f.getName(), this.getContentPropertySeparator()));
            }
        } else if (f.isAnnotationPresent(OriginalFileName.class)) {
            LOGGER.trace((Object)String.format("%s.%s is @OriginalFileName", f.getDeclaringClass().getCanonicalName(), f.getName()));
            String propertyName = this.fullyQualify(path, this.propertyName(f.getName()), this.getKeySeparator());
            if (StringUtils.hasLength((String)propertyName)) {
                Map<String, ContentProperty> classProperties = this.properties.get(this.key(path, klazz));
                ContentProperty property = classProperties.get(propertyName);
                if (property == null) {
                    property = new ContentProperty();
                    classProperties.put(propertyName, property);
                }
                this.updateContentProperty(property::setOriginalFileNamePropertyPath, this.fullyQualify(path, f.getName(), this.getContentPropertySeparator()));
            }
        }
        return true;
    }

    protected void updateContentProperty(Consumer<String> propertyPathField, String propertyPath) {
        propertyPathField.accept(propertyPath);
    }

    protected String fullyQualify(String path, String name, CharSequence separator) {
        String fqName = name;
        if (StringUtils.hasLength((String)path)) {
            String propertyPath = path.replaceAll("/", separator.toString());
            fqName = String.format("%s%s%s", propertyPath, separator, fqName);
        }
        return fqName;
    }

    protected String propertyName(String name) {
        if (!StringUtils.hasLength((String)name)) {
            return name;
        }
        String propertyName = this.calculateName(name);
        if (propertyName != null) {
            return propertyName;
        }
        String[] segments = ContentPropertyMappingContextVisitor.split(name);
        if (segments.length == 1) {
            return segments[0];
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < segments.length - 1; ++i) {
            b.append(segments[i]);
        }
        return b.toString();
    }

    protected boolean isNotRootContentProperty(String path) {
        return StringUtils.hasLength((String)path);
    }

    protected String calculateName(String name) {
        Pattern p = Pattern.compile("^(.+)(Id|Len|Length|MimeType|Mimetype|ContentType|(?<!Mime|Content)Type|(?<!Original)FileName|(?<!Original)Filename|OriginalFileName|OriginalFilename)$");
        Matcher m = p.matcher(name);
        if (!m.matches()) {
            return null;
        }
        return m.group(1);
    }

    protected static String[] split(String name) {
        if (!StringUtils.hasLength((String)name)) {
            return new String[0];
        }
        return name.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
    }

    public Map<Class<?>, Boolean> getLooseModes() {
        return this.looseModes;
    }

    public CharSequence getKeySeparator() {
        return this.keySeparator;
    }

    public CharSequence getContentPropertySeparator() {
        return this.contentPropertySeparator;
    }
}

