/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.commons.storeservice;

import org.springframework.content.commons.storeservice.StoreFilter;
import org.springframework.content.commons.storeservice.StoreInfo;
import org.springframework.content.commons.storeservice.StoreResolver;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public interface Stores {
    public static final StoreFilter MATCH_ALL = new StoreFilter(){

        @Override
        public String name() {
            return "MATCH_ALL";
        }

        @Override
        public boolean matches(StoreInfo info) {
            return true;
        }
    };

    public static StoreFilter withDomainClass(final Class<?> domainClass) {
        Assert.notNull(domainClass);
        return new StoreFilter(){

            @Override
            public String name() {
                return domainClass.getCanonicalName();
            }

            @Override
            public boolean matches(StoreInfo info) {
                return domainClass.equals(info.getDomainObjectClass());
            }
        };
    }

    public void addStoreResolver(String var1, StoreResolver var2);

    public StoreInfo getStore(Class<?> var1, StoreFilter var2);

    public StoreInfo[] getStores(StoreFilter var1);

    public StoreInfo[] getStores(Class<?> var1);

    public StoreInfo[] getStores(Class<?> var1, StoreFilter var2);
}

