/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.commons.repository;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.StoreInvoker;
import org.springframework.util.Assert;

public class StoreInvokerImpl
implements StoreInvoker {
    private static final Log LOGGER = LogFactory.getLog(StoreInvokerImpl.class);
    private Class<?> domainClass = null;
    private Class<? extends Serializable> contentIdClass = null;
    private Method getContentMethod = null;
    private MethodInvocation invocation = null;

    public StoreInvokerImpl(Class<?> domainClass, Class<? extends Serializable> contentIdClass, MethodInvocation invocation) {
        Assert.notNull(domainClass, (String)"domainClass must not be null");
        this.domainClass = domainClass;
        Assert.notNull(contentIdClass, (String)"contentIdClass must not be null");
        this.contentIdClass = contentIdClass;
        Assert.notNull((Object)invocation, (String)"invocation must not be null");
        this.invocation = invocation;
        try {
            Class<ContentStore> storeClazz = ContentStore.class;
            this.getContentMethod = storeClazz.getMethod("getContent", Object.class);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to get ContentStore.getContentmethod", (Throwable)e);
        }
    }

    @Override
    public Class<?> getDomainClass() {
        return this.domainClass;
    }

    @Override
    public Class<? extends Serializable> getContentIdClass() {
        return this.contentIdClass;
    }

    @Override
    public InputStream invokeGetContent() {
        try {
            return (InputStream)this.getContentMethod.invoke(this.invocation.getThis(), this.invocation.getArguments()[0]);
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)String.format("Unable to get content for inovcation", this.invocation.getMethod().getName()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error((Object)String.format("Unable to get content for inovcation", this.invocation.getMethod().getName()), (Throwable)e);
        }
        return null;
    }
}

