/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.commons.mappingcontext;

import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.NullValueInNestedPathException;
import org.springframework.content.commons.mappingcontext.Condition;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.Assert;

public class ContentProperty {
    private String contentPropertyPath;
    private String contentIdPropertyPath;
    private TypeDescriptor contentIdType;
    private String contentLengthPropertyPath;
    private TypeDescriptor contentLengthType;
    private String mimeTypePropertyPath;
    private String originalFileNamePropertyPath;

    public Object getCustomProperty(Object entity, String propertyName) {
        String customContentPropertyPath = this.contentPropertyPath + StringUtils.capitalize((String)propertyName);
        BeanWrapper wrapper = this.getBeanWrapperForRead(entity);
        try {
            return wrapper.getPropertyValue(customContentPropertyPath);
        }
        catch (NullValueInNestedPathException nvinpe) {
            return null;
        }
    }

    public void setCustomProperty(Object entity, String propertyName, Object value) {
        String customContentPropertyPath = this.contentPropertyPath + StringUtils.capitalize((String)propertyName);
        BeanWrapper wrapper = this.getBeanWrapperForWrite(entity);
        wrapper.setPropertyValue(customContentPropertyPath, value);
    }

    public Object getContentId(Object entity) {
        if (this.contentIdPropertyPath == null) {
            return null;
        }
        BeanWrapper wrapper = this.getBeanWrapperForRead(entity);
        try {
            return wrapper.getPropertyValue(this.contentIdPropertyPath);
        }
        catch (NullValueInNestedPathException nvinpe) {
            return null;
        }
    }

    public void setContentId(Object entity, Object value, Condition condition) {
        TypeDescriptor t;
        if (this.contentIdPropertyPath == null) {
            return;
        }
        BeanWrapper wrapper = this.getBeanWrapperForWrite(entity);
        if (condition != null && !condition.matches(t = wrapper.getPropertyTypeDescriptor(this.contentIdPropertyPath))) {
            return;
        }
        wrapper.setPropertyValue(this.contentIdPropertyPath, value);
    }

    public TypeDescriptor getContentIdType(Object entity) {
        Assert.notNull((Object)this.contentIdType, (String)"content id property type must be set");
        return this.contentIdType;
    }

    public TypeDescriptor getContentIdType() {
        Assert.notNull((Object)this.contentIdType, (String)"content id property type must be set");
        return this.contentIdType;
    }

    public void setContentIdType(TypeDescriptor descriptor) {
        this.contentIdType = descriptor;
    }

    public Object getContentLength(Object entity) {
        if (this.contentLengthPropertyPath == null) {
            return 0L;
        }
        BeanWrapper wrapper = this.getBeanWrapperForRead(entity);
        try {
            return wrapper.getPropertyValue(this.contentLengthPropertyPath);
        }
        catch (NullValueInNestedPathException nvinpe) {
            return null;
        }
    }

    public void setContentLength(Object entity, Object value) {
        if (this.contentLengthPropertyPath == null) {
            return;
        }
        BeanWrapper wrapper = this.getBeanWrapperForWrite(entity);
        wrapper.setPropertyValue(this.contentLengthPropertyPath, value);
    }

    public TypeDescriptor getContentLengthType() {
        Assert.notNull((Object)this.contentLengthType, (String)"content length property type must be set");
        return this.contentLengthType;
    }

    public void setContentLengthType(TypeDescriptor descriptor) {
        this.contentLengthType = descriptor;
    }

    public Object getMimeType(Object entity) {
        if (this.mimeTypePropertyPath == null) {
            return null;
        }
        BeanWrapper wrapper = this.getBeanWrapperForRead(entity);
        try {
            return wrapper.getPropertyValue(this.mimeTypePropertyPath);
        }
        catch (NullValueInNestedPathException nvinpe) {
            return null;
        }
    }

    public void setMimeType(Object entity, Object value) {
        if (this.mimeTypePropertyPath == null) {
            return;
        }
        BeanWrapper wrapper = this.getBeanWrapperForWrite(entity);
        wrapper.setPropertyValue(this.mimeTypePropertyPath, value);
    }

    public void setOriginalFileName(Object entity, Object value) {
        if (this.originalFileNamePropertyPath == null) {
            return;
        }
        BeanWrapper wrapper = this.getBeanWrapperForWrite(entity);
        wrapper.setPropertyValue(this.originalFileNamePropertyPath, value);
    }

    public Object getOriginalFileName(Object entity) {
        if (this.originalFileNamePropertyPath == null) {
            return null;
        }
        BeanWrapper wrapper = this.getBeanWrapperForRead(entity);
        try {
            return wrapper.getPropertyValue(this.originalFileNamePropertyPath);
        }
        catch (NullValueInNestedPathException nvinpe) {
            return null;
        }
    }

    private BeanWrapper getBeanWrapperForRead(Object entity) {
        BeanWrapperImpl wrapper = new BeanWrapperImpl(entity);
        return wrapper;
    }

    private BeanWrapper getBeanWrapperForWrite(Object entity) {
        BeanWrapperImpl wrapper = new BeanWrapperImpl(entity);
        wrapper.setAutoGrowNestedPaths(true);
        return wrapper;
    }

    @Generated
    public String getContentPropertyPath() {
        return this.contentPropertyPath;
    }

    @Generated
    public String getContentIdPropertyPath() {
        return this.contentIdPropertyPath;
    }

    @Generated
    public String getContentLengthPropertyPath() {
        return this.contentLengthPropertyPath;
    }

    @Generated
    public String getMimeTypePropertyPath() {
        return this.mimeTypePropertyPath;
    }

    @Generated
    public String getOriginalFileNamePropertyPath() {
        return this.originalFileNamePropertyPath;
    }

    @Generated
    public void setContentPropertyPath(String contentPropertyPath) {
        this.contentPropertyPath = contentPropertyPath;
    }

    @Generated
    public void setContentIdPropertyPath(String contentIdPropertyPath) {
        this.contentIdPropertyPath = contentIdPropertyPath;
    }

    @Generated
    public void setContentLengthPropertyPath(String contentLengthPropertyPath) {
        this.contentLengthPropertyPath = contentLengthPropertyPath;
    }

    @Generated
    public void setMimeTypePropertyPath(String mimeTypePropertyPath) {
        this.mimeTypePropertyPath = mimeTypePropertyPath;
    }

    @Generated
    public void setOriginalFileNamePropertyPath(String originalFileNamePropertyPath) {
        this.originalFileNamePropertyPath = originalFileNamePropertyPath;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentProperty)) {
            return false;
        }
        ContentProperty other = (ContentProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$contentPropertyPath = this.getContentPropertyPath();
        String other$contentPropertyPath = other.getContentPropertyPath();
        if (this$contentPropertyPath == null ? other$contentPropertyPath != null : !this$contentPropertyPath.equals(other$contentPropertyPath)) {
            return false;
        }
        String this$contentIdPropertyPath = this.getContentIdPropertyPath();
        String other$contentIdPropertyPath = other.getContentIdPropertyPath();
        if (this$contentIdPropertyPath == null ? other$contentIdPropertyPath != null : !this$contentIdPropertyPath.equals(other$contentIdPropertyPath)) {
            return false;
        }
        TypeDescriptor this$contentIdType = this.getContentIdType();
        TypeDescriptor other$contentIdType = other.getContentIdType();
        if (this$contentIdType == null ? other$contentIdType != null : !this$contentIdType.equals(other$contentIdType)) {
            return false;
        }
        String this$contentLengthPropertyPath = this.getContentLengthPropertyPath();
        String other$contentLengthPropertyPath = other.getContentLengthPropertyPath();
        if (this$contentLengthPropertyPath == null ? other$contentLengthPropertyPath != null : !this$contentLengthPropertyPath.equals(other$contentLengthPropertyPath)) {
            return false;
        }
        TypeDescriptor this$contentLengthType = this.getContentLengthType();
        TypeDescriptor other$contentLengthType = other.getContentLengthType();
        if (this$contentLengthType == null ? other$contentLengthType != null : !this$contentLengthType.equals(other$contentLengthType)) {
            return false;
        }
        String this$mimeTypePropertyPath = this.getMimeTypePropertyPath();
        String other$mimeTypePropertyPath = other.getMimeTypePropertyPath();
        if (this$mimeTypePropertyPath == null ? other$mimeTypePropertyPath != null : !this$mimeTypePropertyPath.equals(other$mimeTypePropertyPath)) {
            return false;
        }
        String this$originalFileNamePropertyPath = this.getOriginalFileNamePropertyPath();
        String other$originalFileNamePropertyPath = other.getOriginalFileNamePropertyPath();
        return !(this$originalFileNamePropertyPath == null ? other$originalFileNamePropertyPath != null : !this$originalFileNamePropertyPath.equals(other$originalFileNamePropertyPath));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContentProperty;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $contentPropertyPath = this.getContentPropertyPath();
        result = result * 59 + ($contentPropertyPath == null ? 43 : $contentPropertyPath.hashCode());
        String $contentIdPropertyPath = this.getContentIdPropertyPath();
        result = result * 59 + ($contentIdPropertyPath == null ? 43 : $contentIdPropertyPath.hashCode());
        TypeDescriptor $contentIdType = this.getContentIdType();
        result = result * 59 + ($contentIdType == null ? 43 : $contentIdType.hashCode());
        String $contentLengthPropertyPath = this.getContentLengthPropertyPath();
        result = result * 59 + ($contentLengthPropertyPath == null ? 43 : $contentLengthPropertyPath.hashCode());
        TypeDescriptor $contentLengthType = this.getContentLengthType();
        result = result * 59 + ($contentLengthType == null ? 43 : $contentLengthType.hashCode());
        String $mimeTypePropertyPath = this.getMimeTypePropertyPath();
        result = result * 59 + ($mimeTypePropertyPath == null ? 43 : $mimeTypePropertyPath.hashCode());
        String $originalFileNamePropertyPath = this.getOriginalFileNamePropertyPath();
        result = result * 59 + ($originalFileNamePropertyPath == null ? 43 : $originalFileNamePropertyPath.hashCode());
        return result;
    }
}

