/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.commons.repository.factory;

import internal.org.springframework.content.commons.config.StoreFragment;
import internal.org.springframework.content.commons.config.StoreFragments;
import internal.org.springframework.content.commons.store.factory.ReactiveStoreImpl;
import internal.org.springframework.content.commons.store.factory.StoreExceptionTranslatorInterceptor;
import internal.org.springframework.content.commons.store.factory.StoreFactory;
import internal.org.springframework.content.commons.store.factory.StoreImpl;
import internal.org.springframework.content.commons.store.factory.StoreMethodInterceptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.fragments.ParameterTypeAware;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.ReactiveContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.repository.StoreExtension;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.util.Assert;

@Deprecated
public abstract class AbstractStoreFactoryBean
implements BeanFactoryAware,
InitializingBean,
FactoryBean<Store<? extends Serializable>>,
BeanClassLoaderAware,
ApplicationEventPublisherAware,
StoreFactory {
    private static Log logger = LogFactory.getLog(AbstractStoreFactoryBean.class);
    protected static boolean REACTIVE_STORAGE = false;
    private Class<? extends Store> storeInterface;
    private ClassLoader classLoader;
    private ApplicationEventPublisher publisher;
    private org.springframework.content.commons.store.Store<? extends Serializable> store;
    @Autowired(required=false)
    private Set<StoreExtension> extensions = Collections.emptySet();
    private StoreFragments storeFragments = new StoreFragments(Collections.EMPTY_LIST);
    private BeanFactory beanFactory;

    protected AbstractStoreFactoryBean(Class<? extends Store> storeInterface) {
        Assert.notNull(storeInterface, (String)"storeInterface must not be null");
        this.storeInterface = storeInterface;
    }

    @Autowired
    public void setStoreFragments(StoreFragments storeFragments) {
        this.storeFragments = storeFragments;
    }

    @Override
    public Class<? extends Store> getStoreInterface() {
        return this.storeInterface;
    }

    public org.springframework.content.commons.store.Store<Serializable> getStore() {
        return this.getObject();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    public org.springframework.content.commons.store.Store<? extends Serializable> getObject() {
        return this.initAndReturn();
    }

    public Class<? extends org.springframework.content.commons.store.Store<? extends Serializable>> getObjectType() {
        return this.storeInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.initAndReturn();
    }

    private org.springframework.content.commons.store.Store<? extends Serializable> initAndReturn() {
        if (this.store == null) {
            this.store = this.createContentStore();
        }
        return this.store;
    }

    protected org.springframework.content.commons.store.Store<? extends Serializable> createContentStore() {
        Object target = this.getContentStoreImpl();
        ProxyFactory result = new ProxyFactory();
        result.setTarget(target);
        if (!ClassUtils.getAllInterfaces(this.storeInterface).contains(org.springframework.content.commons.store.ReactiveContentStore.class) && !ClassUtils.getAllInterfaces(this.storeInterface).contains(ReactiveContentStore.class)) {
            result.setInterfaces(new Class[]{this.storeInterface, Store.class, AssociativeStore.class, ContentStore.class, org.springframework.content.commons.store.Store.class, org.springframework.content.commons.store.AssociativeStore.class, org.springframework.content.commons.store.ContentStore.class, ParameterTypeAware.class});
        } else {
            result.setInterfaces(new Class[]{this.storeInterface, Store.class, ReactiveContentStore.class, org.springframework.content.commons.store.Store.class, org.springframework.content.commons.store.ReactiveContentStore.class, ParameterTypeAware.class});
        }
        HashMap<Method, StoreExtension> extensionsMap = new HashMap<Method, StoreExtension>();
        try {
            for (StoreExtension extension : this.extensions) {
                for (Method method : extension.getMethods()) {
                    extensionsMap.put(method, extension);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to setup extensions", (Throwable)e);
        }
        this.addProxyAdvice(result, this.beanFactory);
        StoreMethodInterceptor intercepter = new StoreMethodInterceptor();
        if (!ClassUtils.getAllInterfaces(this.storeInterface).contains(org.springframework.content.commons.store.ReactiveContentStore.class) && !ClassUtils.getAllInterfaces(this.storeInterface).contains(ReactiveContentStore.class)) {
            this.storeFragments.add(new StoreFragment<StoreImpl>(this.storeInterface, new StoreImpl(this.storeInterface, (Store)target, this.publisher, Paths.get(System.getProperty("java.io.tmpdir"), new String[0]))));
        } else {
            this.storeFragments.add(new StoreFragment<ReactiveStoreImpl>(this.storeInterface, new ReactiveStoreImpl((org.springframework.content.commons.store.ReactiveContentStore)target, this.publisher)));
        }
        intercepter.setStoreFragments(this.storeFragments);
        result.addAdvice((Advice)new StoreExceptionTranslatorInterceptor(this.beanFactory));
        result.addAdvice((Advice)intercepter);
        return (org.springframework.content.commons.store.Store)result.getProxy(this.classLoader);
    }

    public static Class<?> getDomainClass(Class<?> repositoryClass) {
        return AbstractStoreFactoryBean.getStoreParameter(repositoryClass, 0);
    }

    public static Class<? extends Serializable> getContentIdClass(Class<?> repositoryClass) {
        return AbstractStoreFactoryBean.getStoreParameter(repositoryClass, 1);
    }

    private static Class<?> getStoreParameter(Class<?> repositoryClass, int index) {
        Type[] types;
        Class clazz = null;
        for (Type t : types = repositoryClass.getGenericInterfaces()) {
            if (!(t instanceof ParameterizedType)) continue;
            ParameterizedType pt = (ParameterizedType)t;
            if (pt.getRawType().getTypeName().equals(org.springframework.content.commons.store.Store.class.getCanonicalName())) {
                types = pt.getActualTypeArguments();
                if (types.length != 1) {
                    throw new IllegalStateException(String.format("Store class %s must have a contentId type", repositoryClass.getCanonicalName()));
                }
                if (!(types[0] instanceof Class)) continue;
                clazz = (Class)types[0];
                continue;
            }
            if (!pt.getRawType().getTypeName().equals(org.springframework.content.commons.store.AssociativeStore.class.getCanonicalName()) && !pt.getRawType().getTypeName().equals(org.springframework.content.commons.store.ContentStore.class.getCanonicalName())) continue;
            types = pt.getActualTypeArguments();
            if (types.length != 2) {
                throw new IllegalStateException(String.format("ContentRepository class %s must have domain and contentId types", repositoryClass.getCanonicalName()));
            }
            if (!(types[index] instanceof Class)) continue;
            clazz = (Class)types[index];
        }
        return clazz;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected void addProxyAdvice(ProxyFactory result, BeanFactory beanFactory) {
    }

    protected abstract Object getContentStoreImpl();

    static {
        try {
            REACTIVE_STORAGE = Class.forName("org.springframework.web.reactive.config.WebFluxConfigurationSupport") != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

