/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.commons.utils;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.content.commons.utils.Condition;
import org.springframework.util.ReflectionUtils;

public final class BeanUtils {
    private static final Condition MATCHING_CONDITION = new Condition(){

        @Override
        public boolean matches(Field field) {
            return true;
        }
    };

    private BeanUtils() {
    }

    public static boolean hasFieldWithAnnotation(Object domainObj, Class<? extends Annotation> annotationClass) throws SecurityException, BeansException {
        Field field = BeanUtils.findFieldWithAnnotation(domainObj, annotationClass);
        return field != null && field.getAnnotation(annotationClass) != null;
    }

    public static Field findFieldWithAnnotation(Object domainObj, Class<? extends Annotation> annotationClass) throws SecurityException, BeansException {
        BeanWrapperImpl wrapper = new BeanWrapperImpl(domainObj);
        Field candidate = BeanUtils.findFieldWithAnnotation(domainObj.getClass(), annotationClass, (BeanWrapper)wrapper);
        if (candidate != null) {
            return candidate;
        }
        return null;
    }

    public static Field findFieldWithAnnotation(Class<?> domainObjClass, Class<? extends Annotation> annotationClass) throws SecurityException, BeansException {
        BeanWrapperImpl wrapper = new BeanWrapperImpl(domainObjClass);
        Field candidate = BeanUtils.findFieldWithAnnotation(domainObjClass, annotationClass, (BeanWrapper)wrapper);
        if (candidate != null) {
            return candidate;
        }
        return null;
    }

    private static Field findFieldWithAnnotation(Class<?> domainObjClass, Class<? extends Annotation> annotationClass, BeanWrapper wrapper) {
        PropertyDescriptor[] descriptors = wrapper.getPropertyDescriptors();
        for (PropertyDescriptor descriptor : descriptors) {
            Field candidate = BeanUtils.getField(domainObjClass, descriptor.getName());
            if (candidate == null || candidate.getAnnotation(annotationClass) == null) continue;
            return candidate;
        }
        for (Field field : BeanUtils.getAllFields(domainObjClass)) {
            if (field.getAnnotation(annotationClass) == null) continue;
            return field;
        }
        return null;
    }

    public static Field[] findFieldsWithAnnotation(Class<?> domainObjClass, Class<? extends Annotation> annotationClass, BeanWrapper wrapper) {
        ArrayList<Field> fields = new ArrayList<Field>();
        PropertyDescriptor[] descriptors = wrapper.getPropertyDescriptors();
        for (PropertyDescriptor descriptor : descriptors) {
            Field candidate = BeanUtils.getField(domainObjClass, descriptor.getName());
            if (candidate == null || candidate.getAnnotation(annotationClass) == null) continue;
            fields.add(candidate);
        }
        for (Field field : BeanUtils.getAllFields(domainObjClass)) {
            if (field.getAnnotation(annotationClass) == null || fields.contains(field)) continue;
            fields.add(field);
        }
        return fields.toArray(new Field[0]);
    }

    protected static List<Field> getAllFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            BeanUtils.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    protected static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            BeanUtils.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    protected static Field getField(Class<?> type, String fieldName) {
        for (Field field : BeanUtils.getAllFields(type)) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public static Class<?> getFieldWithAnnotationType(Object domainObj, Class<? extends Annotation> annotationClass) throws SecurityException, BeansException {
        Class<?> type = null;
        Field field = BeanUtils.findFieldWithAnnotation(domainObj, annotationClass);
        if (field != null && field.getAnnotation(annotationClass) != null) {
            type = field.getType();
        }
        return type;
    }

    public static Object getFieldWithAnnotation(Object domainObj, Class<? extends Annotation> annotationClass) throws SecurityException, BeansException {
        Object value = null;
        Field field = BeanUtils.findFieldWithAnnotation(domainObj, annotationClass);
        if (field != null && field.getAnnotation(annotationClass) != null) {
            try {
                PropertyDescriptor descriptor = org.springframework.beans.BeanUtils.getPropertyDescriptor(domainObj.getClass(), (String)field.getName());
                if (descriptor != null) {
                    BeanWrapperImpl wrapper = new BeanWrapperImpl(domainObj);
                    value = wrapper.getPropertyValue(field.getName());
                } else {
                    value = ReflectionUtils.getField((Field)field, (Object)domainObj);
                }
                return value;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return value;
    }

    public static Object[] getFieldsWithAnnotation(Object domainObj, Class<? extends Annotation> annotationClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<Object> values = new ArrayList<Object>();
        PropertyDescriptor[] descriptors = new BeanWrapperImpl(domainObj).getPropertyDescriptors();
        for (PropertyDescriptor descriptor : descriptors) {
            Field candidate = BeanUtils.getField(domainObj.getClass(), descriptor.getName());
            if (candidate == null || candidate.getAnnotation(annotationClass) == null) continue;
            try {
                values.add(candidate.get(domainObj));
                fields.add(candidate);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        for (Field field : BeanUtils.getAllFields(domainObj.getClass())) {
            if (field.getAnnotation(annotationClass) == null || fields.contains(field)) continue;
            try {
                values.add(field.get(domainObj));
                fields.add(field);
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return values.toArray();
    }

    public static void setFieldWithAnnotation(Object domainObj, Class<? extends Annotation> annotationClass, Object value) {
        BeanUtils.setFieldWithAnnotationConditionally(domainObj, annotationClass, value, MATCHING_CONDITION);
    }

    public static void setFieldWithAnnotationConditionally(Object domainObj, Class<? extends Annotation> annotationClass, Object value, Condition condition) {
        Field field = BeanUtils.findFieldWithAnnotation(domainObj, annotationClass);
        if (field != null && field.getAnnotation(annotationClass) != null && condition.matches(field)) {
            try {
                PropertyDescriptor descriptor = org.springframework.beans.BeanUtils.getPropertyDescriptor(domainObj.getClass(), (String)field.getName());
                if (descriptor != null) {
                    BeanWrapperImpl wrapper = new BeanWrapperImpl(domainObj);
                    wrapper.setPropertyValue(field.getName(), value);
                    return;
                }
                ReflectionUtils.setField((Field)field, (Object)domainObj, (Object)value);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static Object getDefaultValueForType(Class<?> fieldType) {
        if (fieldType == Integer.TYPE || fieldType == Double.TYPE) {
            return 0;
        }
        if (fieldType == Boolean.TYPE) {
            return false;
        }
        if (fieldType == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (fieldType == Byte.TYPE) {
            return (byte)0;
        }
        if (fieldType == Short.TYPE) {
            return (short)0;
        }
        if (fieldType == Long.TYPE) {
            return 0L;
        }
        if (fieldType == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        return null;
    }
}

