/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.commons.utils;

import jakarta.persistence.Id;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.core.annotation.AnnotationUtils;

public final class DomainObjectUtils {
    private static boolean JAVAX_PERSISTENCE_ID_CLASS_PRESENT = false;

    private DomainObjectUtils() {
    }

    public static final Object getId(Object entity) {
        Object id;
        block4: {
            block3: {
                PropertyDescriptor[] propertyDescriptors;
                id = null;
                if (!JAVAX_PERSISTENCE_ID_CLASS_PRESENT || !BeanUtils.hasFieldWithAnnotation(entity, Id.class)) break block3;
                id = BeanUtils.getFieldWithAnnotation(entity, Id.class);
                if (id != null) break block4;
                for (PropertyDescriptor propertyDescriptor : propertyDescriptors = new BeanWrapperImpl(entity).getPropertyDescriptors()) {
                    if (AnnotationUtils.findAnnotation((Method)propertyDescriptor.getReadMethod(), Id.class) == null) continue;
                    return new BeanWrapperImpl(entity).getPropertyValue(propertyDescriptor.getName());
                }
                break block4;
            }
            if (BeanUtils.hasFieldWithAnnotation(entity, org.springframework.data.annotation.Id.class) && (id = BeanUtils.getFieldWithAnnotation(entity, org.springframework.data.annotation.Id.class)) == null) {
                PropertyDescriptor[] propertyDescriptors;
                for (PropertyDescriptor propertyDescriptor : propertyDescriptors = new BeanWrapperImpl(entity).getPropertyDescriptors()) {
                    if (AnnotationUtils.findAnnotation((Method)propertyDescriptor.getReadMethod(), org.springframework.data.annotation.Id.class) == null) continue;
                    return new BeanWrapperImpl(entity).getPropertyValue(propertyDescriptor.getName());
                }
            }
        }
        return id;
    }

    public static final Field getIdField(Class<?> domainClass) {
        if (JAVAX_PERSISTENCE_ID_CLASS_PRESENT && BeanUtils.findFieldWithAnnotation(domainClass, Id.class) != null) {
            return BeanUtils.findFieldWithAnnotation(domainClass, Id.class);
        }
        if (BeanUtils.findFieldWithAnnotation(domainClass, org.springframework.data.annotation.Id.class) != null) {
            return BeanUtils.findFieldWithAnnotation(domainClass, org.springframework.data.annotation.Id.class);
        }
        return null;
    }

    static {
        try {
            JAVAX_PERSISTENCE_ID_CLASS_PRESENT = DomainObjectUtils.class.getClassLoader().loadClass("jakarta.persistence.Id") != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

