/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.commons.utils;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.repository.ReactiveContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.store.ContentStore;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.Pair;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public final class StoreInterfaceUtils {
    private StoreInterfaceUtils() {
    }

    public static Pair<Optional<Class<?>>, Class<? extends Serializable>> getStoreTypes(Class<? extends Store> storeClass) {
        Class[] candidateStoreClasses;
        List types = null;
        for (Class candidateStoreClass : candidateStoreClasses = new Class[]{ContentStore.class, org.springframework.content.commons.store.AssociativeStore.class, org.springframework.content.commons.store.Store.class, org.springframework.content.commons.store.ReactiveContentStore.class, org.springframework.content.commons.repository.ContentStore.class, AssociativeStore.class, Store.class, ReactiveContentStore.class}) {
            try {
                types = ClassTypeInformation.from(storeClass).getRequiredSuperTypeInformation(candidateStoreClass).getTypeArguments();
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        Optional<Object> domainClass = null;
        Class idClass = null;
        if (types.size() == 2) {
            domainClass = Optional.of(((TypeInformation)types.get(0)).getType());
            Assert.isAssignable(Serializable.class, (Class)((TypeInformation)types.get(1)).getType());
            idClass = ((TypeInformation)types.get(1)).getType();
        } else if (types.size() == 1) {
            domainClass = Optional.empty();
            Assert.isAssignable(Serializable.class, (Class)((TypeInformation)types.get(0)).getType());
            idClass = ((TypeInformation)types.get(0)).getType();
        }
        return Pair.of(domainClass, idClass);
    }
}

