/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.commons.store.factory;

import java.util.ArrayList;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.content.commons.store.StoreAccessException;
import org.springframework.content.commons.store.StoreExceptionTranslator;

public class StoreExceptionTranslatorInterceptor
implements MethodInterceptor {
    private final BeanFactory beanFactory;
    private List<StoreExceptionTranslator> translators = null;

    public StoreExceptionTranslatorInterceptor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            return invocation.proceed();
        }
        catch (RuntimeException re) {
            if (re instanceof StoreAccessException) {
                throw re;
            }
            if (this.translators == null) {
                this.translators = new ArrayList<StoreExceptionTranslator>();
                this.beanFactory.getBeanProvider(StoreExceptionTranslator.class).orderedStream().forEach(this.translators::add);
            }
            Object sae = null;
            for (int i = 0; i < this.translators.size() && sae == null; ++i) {
                sae = this.translators.get(i).translate(re);
            }
            throw sae != null ? sae : re;
        }
    }
}

