/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.encryption.engine;

import internal.org.springframework.content.encryption.engine.EnsureSingleSkipInputStream;
import internal.org.springframework.content.encryption.engine.SkippingInputStream;
import internal.org.springframework.content.encryption.engine.ZeroPrefixedInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.function.Function;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.springframework.content.encryption.engine.ContentEncryptionEngine;

public class AesCtrEncryptionEngine
implements ContentEncryptionEngine {
    private final KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
    private static final SecureRandom secureRandom = new SecureRandom();
    private static final int AES_BLOCK_SIZE_BYTES = 16;
    private static final int IV_SIZE_BYTES = 16;

    public AesCtrEncryptionEngine(int keySizeBits) {
        this.keyGenerator.init(keySizeBits, secureRandom);
    }

    @Override
    public ContentEncryptionEngine.EncryptionParameters createNewParameters() {
        SecretKey secretKey = this.keyGenerator.generateKey();
        byte[] iv = new byte[16];
        secureRandom.nextBytes(iv);
        return new ContentEncryptionEngine.EncryptionParameters(secretKey, iv);
    }

    private Cipher initializeCipher(ContentEncryptionEngine.EncryptionParameters parameters, boolean forEncryption) {
        Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
        cipher.init(forEncryption ? 1 : 2, (Key)parameters.getSecretKey(), new IvParameterSpec(parameters.getInitializationVector()));
        return cipher;
    }

    @Override
    public InputStream encrypt(InputStream plainText, ContentEncryptionEngine.EncryptionParameters encryptionParameters) {
        return new CipherInputStream(plainText, this.initializeCipher(encryptionParameters, true));
    }

    @Override
    public InputStream decrypt(Function<ContentEncryptionEngine.InputStreamRequestParameters, InputStream> cipherTextStreamRequest, ContentEncryptionEngine.EncryptionParameters encryptionParameters, ContentEncryptionEngine.InputStreamRequestParameters requestParameters) {
        long blockStartOffset = AesCtrEncryptionEngine.calculateBlockOffset(requestParameters.getStartByteOffset());
        byte[] adjustedIv = this.adjustIvForOffset(encryptionParameters.getInitializationVector(), blockStartOffset);
        ContentEncryptionEngine.EncryptionParameters adjustedParameters = new ContentEncryptionEngine.EncryptionParameters(encryptionParameters.getSecretKey(), adjustedIv);
        long byteStartOffset = blockStartOffset * 16L;
        InputStream cipherTextStream = cipherTextStreamRequest.apply(requestParameters);
        Cipher cipher = this.initializeCipher(adjustedParameters, false);
        return new ZeroPrefixedInputStream(new EnsureSingleSkipInputStream(new CipherInputStream(new SkippingInputStream(cipherTextStream, byteStartOffset), cipher)), byteStartOffset);
    }

    private static long calculateBlockOffset(long offsetBytes) {
        return (offsetBytes - offsetBytes % 16L) / 16L;
    }

    private byte[] adjustIvForOffset(byte[] iv, long offsetBlocks) {
        if (offsetBlocks == 0L) {
            return iv;
        }
        BigInteger initialIv = new BigInteger(1, iv);
        byte[] bigintBytes = initialIv.add(BigInteger.valueOf(offsetBlocks)).toByteArray();
        if (bigintBytes.length == 16) {
            return bigintBytes;
        }
        if (bigintBytes.length > 16) {
            return Arrays.copyOfRange(bigintBytes, bigintBytes.length - 16, bigintBytes.length);
        }
        byte[] ivBytes = new byte[16];
        System.arraycopy(bigintBytes, 0, ivBytes, 16 - bigintBytes.length, bigintBytes.length);
        return ivBytes;
    }
}

