/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.encryption.engine;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class EnsureSingleSkipInputStream
extends FilterInputStream {
    public EnsureSingleSkipInputStream(InputStream in) {
        super(in);
    }

    @Override
    public long skip(long n) throws IOException {
        long totalSkipped = 0L;
        while (totalSkipped < n) {
            long skipAmount = super.skip(n - totalSkipped);
            totalSkipped += skipAmount;
            if (skipAmount != 0L) continue;
            if (this.read() == -1) {
                return totalSkipped;
            }
            ++totalSkipped;
        }
        return n;
    }
}

